/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhm
extends zzgi<Double>
implements zzik<Double>,
zzjz,
RandomAccess {
    private static final zzhm zzup = new zzhm(new double[0], 0);
    private double[] zzuq;
    private int size;

    zzhm() {
        this(new double[10], 0);
    }

    private zzhm(double[] dArray, int n) {
        this.zzuq = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzuq, n2, this.zzuq, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhm)) {
            return super.equals(object);
        }
        zzhm zzhm2 = (zzhm)object;
        if (this.size != zzhm2.size) {
            return false;
        }
        double[] dArray = zzhm2.zzuq;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzuq[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzuq[i]);
            n = n * 31 + zzie.zzab(l);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzuq[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzek();
        if (this.size == this.zzuq.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzuq, 0, dArray, 0, this.size);
            this.zzuq = dArray;
        }
        this.zzuq[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzhm)) {
            return super.addAll(collection);
        }
        zzhm zzhm2 = (zzhm)collection;
        if (zzhm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhm2.size;
        if (n > this.zzuq.length) {
            this.zzuq = Arrays.copyOf(this.zzuq, n);
        }
        System.arraycopy(zzhm2.zzuq, 0, this.zzuq, this.size, zzhm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzuq[i])) continue;
            System.arraycopy(this.zzuq, i + 1, this.zzuq, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        double d = (Double)object;
        zzhm zzhm2 = this;
        zzhm2.zzek();
        zzhm2.zzal(n);
        double d2 = zzhm2.zzuq[n];
        zzhm2.zzuq[n] = d;
        return d2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhm zzhm2 = this;
        zzhm2.zzek();
        zzhm2.zzal(n);
        double d = zzhm2.zzuq[n];
        if (n < zzhm2.size - 1) {
            System.arraycopy(zzhm2.zzuq, n + 1, zzhm2.zzuq, n, zzhm2.size - n - 1);
        }
        --zzhm2.size;
        ++zzhm2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        double d = (Double)object;
        zzhm zzhm2 = this;
        zzhm2.zzek();
        if (n < 0 || n > zzhm2.size) {
            throw new IndexOutOfBoundsException(zzhm2.zzam(n));
        }
        if (zzhm2.size < zzhm2.zzuq.length) {
            System.arraycopy(zzhm2.zzuq, n, zzhm2.zzuq, n + 1, zzhm2.size - n);
        } else {
            double[] dArray = new double[zzhm2.size * 3 / 2 + 1];
            System.arraycopy(zzhm2.zzuq, 0, dArray, 0, n);
            System.arraycopy(zzhm2.zzuq, n, dArray, n + 1, zzhm2.size - n);
            zzhm2.zzuq = dArray;
        }
        zzhm2.zzuq[n] = d;
        ++zzhm2.size;
        ++zzhm2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzc((Double)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzhm zzhm2 = this;
        if (n2 < zzhm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhm(Arrays.copyOf(zzhm2.zzuq, n2), zzhm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzhm zzhm2 = this;
        zzhm2.zzal(n);
        return zzhm2.zzuq[n];
    }

    static {
        zzup.zzej();
    }
}

