/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzx;
    private Tracker<T> zzas;
    private int zzat = 3;
    private boolean zzau = false;
    private int zzav;
    private int zzaw = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzx = detector;
        this.zzas = tracker;
    }

    @Override
    public void release() {
        this.zzas.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzaw == this.zzat) {
                this.zzas.onDone();
                this.zzau = false;
            } else {
                this.zzas.onMissing(detections);
            }
            ++this.zzaw;
            return;
        }
        this.zzaw = 0;
        if (this.zzau) {
            Object object2 = sparseArray.get(this.zzav);
            if (object2 != null) {
                this.zzas.onUpdate(detections, object2);
                return;
            }
            this.zzas.onDone();
            this.zzau = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzau = true;
        this.zzav = n;
        this.zzx.setFocus(this.zzav);
        this.zzas.onNewItem(this.zzav, object);
        this.zzas.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zza(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzat = n;
    }
}

