/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import javax.annotation.concurrent.GuardedBy;

public abstract class Detector<T> {
    private final Object zzah = new Object();
    @GuardedBy(value="processorLock")
    private Processor<T> zzai;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzah;
        synchronized (object) {
            if (this.zzai != null) {
                this.zzai.release();
                this.zzai = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zzf();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zzah;
        synchronized (object) {
            if (detector.zzai == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzai.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zzah;
        synchronized (object) {
            if (this.zzai != null) {
                this.zzai.release();
            }
            this.zzai = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zzal;
        private final Frame.Metadata zzam;
        private final boolean zzan;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzal = sparseArray;
            this.zzam = metadata;
            this.zzan = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzal;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzam;
        }

        public boolean detectorIsOperational() {
            return this.zzan;
        }
    }
}

