/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.vision.L;
import javax.annotation.concurrent.GuardedBy;

public abstract class zzs<T> {
    private final Context zzg;
    private final Object lock = new Object();
    private final String tag;
    private final String zzdm;
    private final String zzdn;
    private boolean zzdo = false;
    private boolean zzdp = false;
    @GuardedBy(value="lock")
    private T zzdq;

    public zzs(Context context, String string, String string2) {
        this.zzg = context;
        this.tag = string;
        String string3 = String.valueOf("com.google.android.gms.vision.dynamite.");
        String string4 = String.valueOf(string2);
        this.zzdm = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        this.zzdn = string2;
    }

    public final boolean isOperational() {
        return this.zzr() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzq() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdq == null) {
                return;
            }
            try {
                this.zzp();
            }
            catch (RemoteException remoteException) {
                Log.e((String)this.tag, (String)"Could not finalize native handle", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T zzr() {
        Object object = this.lock;
        synchronized (object) {
            DynamiteModule dynamiteModule;
            block14: {
                if (this.zzdq != null) {
                    return this.zzdq;
                }
                dynamiteModule = null;
                try {
                    dynamiteModule = DynamiteModule.load((Context)this.zzg, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)this.zzdm);
                }
                catch (DynamiteModule.LoadingException loadingException) {
                    String string = String.format("%s.%s", "com.google.android.gms.vision", this.zzdn);
                    L.d("Cannot load thick client module, fall back to load optional module %s", string);
                    try {
                        dynamiteModule = DynamiteModule.load((Context)this.zzg, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)string);
                    }
                    catch (DynamiteModule.LoadingException loadingException2) {
                        L.e(loadingException2, "Error loading optional module %s", string);
                        if (this.zzdo) break block14;
                        L.d("Broadcasting download intent for dependency %s", this.zzdn);
                        String string2 = this.zzdn;
                        Intent intent = new Intent();
                        intent.setClassName("com.google.android.gms", "com.google.android.gms.vision.DependencyBroadcastReceiverProxy");
                        Intent intent2 = intent;
                        intent2.putExtra("com.google.android.gms.vision.DEPENDENCIES", string2);
                        intent2.setAction("com.google.android.gms.vision.DEPENDENCY");
                        Intent intent3 = intent2;
                        this.zzg.sendBroadcast(intent3);
                        this.zzdo = true;
                    }
                }
            }
            if (dynamiteModule != null) {
                try {
                    this.zzdq = this.zza(dynamiteModule, this.zzg);
                }
                catch (RemoteException | DynamiteModule.LoadingException throwable) {
                    Log.e((String)this.tag, (String)"Error creating remote native handle", (Throwable)throwable);
                }
            }
            if (!this.zzdp && this.zzdq == null) {
                Log.w((String)this.tag, (String)"Native handle not yet available. Reverting to no-op handle.");
                this.zzdp = true;
            } else if (this.zzdp && this.zzdq != null) {
                Log.w((String)this.tag, (String)"Native handle is now available.");
            }
            return this.zzdq;
        }
    }

    protected abstract T zza(DynamiteModule var1, Context var2) throws RemoteException, DynamiteModule.LoadingException;

    protected abstract void zzp() throws RemoteException;
}

