/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgp;
import com.google.android.gms.internal.vision.zzgq;
import com.google.android.gms.internal.vision.zzgs;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzhm;
import com.google.android.gms.internal.vision.zzho;
import com.google.android.gms.internal.vision.zzhz;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzif;
import com.google.android.gms.internal.vision.zzim;
import com.google.android.gms.internal.vision.zzin;
import com.google.android.gms.internal.vision.zziu;
import com.google.android.gms.internal.vision.zzjb;
import com.google.android.gms.internal.vision.zzje;
import com.google.android.gms.internal.vision.zzjy;
import com.google.android.gms.internal.vision.zzkc;
import com.google.android.gms.internal.vision.zzld;
import com.google.android.gms.internal.vision.zzll;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

final class zzgr
extends zzgp {
    private final boolean zztq;
    private final byte[] buffer;
    private int pos;
    private final int zztr;
    private int limit;
    private int tag;
    private int zzts;

    public zzgr(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.zztq = true;
        this.buffer = byteBuffer.array();
        this.zztr = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
        this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
    }

    private final boolean zzen() {
        return this.pos == this.limit;
    }

    @Override
    public final int zzeo() throws IOException {
        if (this.zzen()) {
            return Integer.MAX_VALUE;
        }
        this.tag = this.zzfe();
        if (this.tag == this.zzts) {
            return Integer.MAX_VALUE;
        }
        return this.tag >>> 3;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzep() throws IOException {
        if (this.zzen() || this.tag == this.zzts) {
            return false;
        }
        switch (this.tag & 7) {
            case 0: {
                zzgr zzgr2 = this;
                if (zzgr2.limit - zzgr2.pos >= 10) {
                    byte[] byArray = zzgr2.buffer;
                    int n = zzgr2.pos;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray[n++] < 0) continue;
                        zzgr2.pos = n;
                        return true;
                    }
                } else {
                    zzgr zzgr3 = zzgr2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzgr3.readByte() >= 0) return true;
                    }
                    throw zzin.zzhj();
                }
            }
            case 1: {
                this.zzao(8);
                return true;
            }
            case 2: {
                this.zzao(this.zzfe());
                return true;
            }
            case 5: {
                this.zzao(4);
                return true;
            }
            case 3: {
                zzgr zzgr4 = this;
                int n = zzgr4.zzts;
                zzgr4.zzts = zzgr4.tag >>> 3 << 3 | 4;
                while (zzgr4.zzeo() != Integer.MAX_VALUE && zzgr4.zzep()) {
                }
                if (zzgr4.tag != zzgr4.zzts) {
                    throw zzin.zzhn();
                }
                zzgr4.zzts = n;
                return true;
            }
        }
        throw zzin.zzhm();
    }

    @Override
    public final double readDouble() throws IOException {
        this.zzaq(1);
        return Double.longBitsToDouble(this.zzfi());
    }

    @Override
    public final float readFloat() throws IOException {
        this.zzaq(5);
        return Float.intBitsToFloat(this.zzfh());
    }

    @Override
    public final long zzeq() throws IOException {
        this.zzaq(0);
        return this.zzff();
    }

    @Override
    public final long zzer() throws IOException {
        this.zzaq(0);
        return this.zzff();
    }

    @Override
    public final int zzes() throws IOException {
        this.zzaq(0);
        return this.zzfe();
    }

    @Override
    public final long zzet() throws IOException {
        this.zzaq(1);
        return this.zzfi();
    }

    @Override
    public final int zzeu() throws IOException {
        this.zzaq(5);
        return this.zzfh();
    }

    @Override
    public final boolean zzev() throws IOException {
        this.zzaq(0);
        return this.zzfe() != 0;
    }

    @Override
    public final String readString() throws IOException {
        return this.zzj(false);
    }

    @Override
    public final String zzew() throws IOException {
        return this.zzj(true);
    }

    private final String zzj(boolean bl) throws IOException {
        this.zzaq(2);
        int n = this.zzfe();
        if (n == 0) {
            return "";
        }
        this.zzap(n);
        if (bl && !zzld.zzf(this.buffer, this.pos, this.pos + n)) {
            throw zzin.zzho();
        }
        String string = new String(this.buffer, this.pos, n, zzie.UTF_8);
        this.pos += n;
        return string;
    }

    @Override
    public final <T> T zza(Class<T> clazz, zzho zzho2) throws IOException {
        this.zzaq(2);
        return this.zzb(zzjy.zzij().zzf(clazz), zzho2);
    }

    @Override
    public final <T> T zza(zzkc<T> zzkc2, zzho zzho2) throws IOException {
        this.zzaq(2);
        return this.zzb(zzkc2, zzho2);
    }

    private final <T> T zzb(zzkc<T> zzkc2, zzho zzho2) throws IOException {
        int n;
        int n2 = this.zzfe();
        this.zzap(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            T t = zzkc2.newInstance();
            zzkc2.zza(t, this, zzho2);
            zzkc2.zzj(t);
            if (this.pos != n) {
                throw zzin.zzhn();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.limit = n3;
        }
    }

    @Override
    public final <T> T zzb(Class<T> clazz, zzho zzho2) throws IOException {
        this.zzaq(3);
        return this.zzd(zzjy.zzij().zzf(clazz), zzho2);
    }

    @Override
    public final <T> T zzc(zzkc<T> zzkc2, zzho zzho2) throws IOException {
        this.zzaq(3);
        return this.zzd(zzkc2, zzho2);
    }

    private final <T> T zzd(zzkc<T> zzkc2, zzho zzho2) throws IOException {
        int n = this.zzts;
        this.zzts = this.tag >>> 3 << 3 | 4;
        try {
            T t = zzkc2.newInstance();
            zzkc2.zza(t, this, zzho2);
            zzkc2.zzj(t);
            if (this.tag != this.zzts) {
                throw zzin.zzhn();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zzts = n;
        }
    }

    @Override
    public final zzgs zzex() throws IOException {
        this.zzaq(2);
        int n = this.zzfe();
        if (n == 0) {
            return zzgs.zztt;
        }
        this.zzap(n);
        zzgs zzgs2 = this.zztq ? zzgs.zzb(this.buffer, this.pos, n) : zzgs.zza(this.buffer, this.pos, n);
        this.pos += n;
        return zzgs2;
    }

    @Override
    public final int zzey() throws IOException {
        this.zzaq(0);
        return this.zzfe();
    }

    @Override
    public final int zzez() throws IOException {
        this.zzaq(0);
        return this.zzfe();
    }

    @Override
    public final int zzfa() throws IOException {
        this.zzaq(5);
        return this.zzfh();
    }

    @Override
    public final long zzfb() throws IOException {
        this.zzaq(1);
        return this.zzfi();
    }

    @Override
    public final int zzfc() throws IOException {
        this.zzaq(0);
        return zzhe.zzbb(this.zzfe());
    }

    @Override
    public final long zzfd() throws IOException {
        this.zzaq(0);
        return zzhe.zzr(this.zzff());
    }

    @Override
    public final void zza(List<Double> list) throws IOException {
        if (list instanceof zzhm) {
            zzhm zzhm2 = (zzhm)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzar(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhm2.zzc(Double.longBitsToDouble(this.zzfk()));
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhm2.zzc(this.readDouble());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzar(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Double.longBitsToDouble(this.zzfk()));
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.readDouble());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzb(List<Float> list) throws IOException {
        if (list instanceof zzhz) {
            zzhz zzhz2 = (zzhz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzas(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhz2.zzu(Float.intBitsToFloat(this.zzfj()));
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzhz2.zzu(this.readFloat());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzas(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Float.valueOf(Float.intBitsToFloat(this.zzfj())));
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzc(List<Long> list) throws IOException {
        if (list instanceof zzjb) {
            zzjb zzjb2 = (zzjb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzjb2.zzac(this.zzff());
                    }
                    this.zzat(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzjb2.zzac(this.zzeq());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzin.zzhm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzff());
                }
                this.zzat(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzeq());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzin.zzhm();
    }

    @Override
    public final void zzd(List<Long> list) throws IOException {
        if (list instanceof zzjb) {
            zzjb zzjb2 = (zzjb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzjb2.zzac(this.zzff());
                    }
                    this.zzat(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzjb2.zzac(this.zzer());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzin.zzhm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzff());
                }
                this.zzat(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzer());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzin.zzhm();
    }

    @Override
    public final void zze(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(this.zzfe());
                    }
                    this.zzat(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzes());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzin.zzhm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfe());
                }
                this.zzat(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzes());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzin.zzhm();
    }

    @Override
    public final void zzf(List<Long> list) throws IOException {
        if (list instanceof zzjb) {
            zzjb zzjb2 = (zzjb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzar(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzjb2.zzac(this.zzfk());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzjb2.zzac(this.zzet());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzar(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfk());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzet());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzg(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzas(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(this.zzfj());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzeu());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzas(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfj());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzeu());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzh(List<Boolean> list) throws IOException {
        if (list instanceof zzgq) {
            zzgq zzgq2 = (zzgq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgq2.addBoolean(this.zzfe() != 0);
                    }
                    this.zzat(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzgq2.addBoolean(this.zzev());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzin.zzhm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfe() != 0);
                }
                this.zzat(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzev());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzin.zzhm();
    }

    @Override
    public final void readStringList(List<String> list) throws IOException {
        this.zza(list, false);
    }

    @Override
    public final void zzi(List<String> list) throws IOException {
        this.zza(list, true);
    }

    private final void zza(List<String> list, boolean bl) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzin.zzhm();
        }
        if (list instanceof zziu && !bl) {
            int n2;
            zziu zziu2 = (zziu)list;
            do {
                zziu2.zzc(this.zzex());
                if (this.zzen()) {
                    return;
                }
                n2 = this.pos;
            } while (this.zzfe() == this.tag);
            this.pos = n2;
            return;
        }
        do {
            list.add(this.zzj(bl));
            if (this.zzen()) {
                return;
            }
            n = this.pos;
        } while (this.zzfe() == this.tag);
        this.pos = n;
    }

    @Override
    public final <T> void zza(List<T> list, zzkc<T> zzkc2, zzho zzho2) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzin.zzhm();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzb(zzkc2, zzho2));
            if (this.zzen()) {
                return;
            }
            n = this.pos;
        } while (this.zzfe() == n2);
        this.pos = n;
    }

    @Override
    public final <T> void zzb(List<T> list, zzkc<T> zzkc2, zzho zzho2) throws IOException {
        int n;
        if ((this.tag & 7) != 3) {
            throw zzin.zzhm();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzd(zzkc2, zzho2));
            if (this.zzen()) {
                return;
            }
            n = this.pos;
        } while (this.zzfe() == n2);
        this.pos = n;
    }

    @Override
    public final void zzj(List<zzgs> list) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzin.zzhm();
        }
        do {
            list.add(this.zzex());
            if (this.zzen()) {
                return;
            }
            n = this.pos;
        } while (this.zzfe() == this.tag);
        this.pos = n;
    }

    @Override
    public final void zzk(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(this.zzfe());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzey());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfe());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzey());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzl(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(this.zzfe());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzez());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfe());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzez());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzm(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzas(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(this.zzfj());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzfa());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzas(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfj());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzfa());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzn(List<Long> list) throws IOException {
        if (list instanceof zzjb) {
            zzjb zzjb2 = (zzjb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    this.zzar(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzjb2.zzac(this.zzfk());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzjb2.zzac(this.zzfb());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                this.zzar(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzfk());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzfb());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzo(List<Integer> list) throws IOException {
        if (list instanceof zzif) {
            zzif zzif2 = (zzif)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzif2.zzbs(zzhe.zzbb(this.zzfe()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzif2.zzbs(this.zzfc());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzhe.zzbb(this.zzfe()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzfc());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final void zzp(List<Long> list) throws IOException {
        if (list instanceof zzjb) {
            zzjb zzjb2 = (zzjb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzfe();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzjb2.zzac(zzhe.zzr(this.zzff()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzjb2.zzac(this.zzfd());
                        if (this.zzen()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzfe() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzin.zzhm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzfe();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzhe.zzr(this.zzff()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzfd());
                    if (this.zzen()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzfe() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzin.zzhm();
            }
        }
    }

    @Override
    public final <K, V> void zza(Map<K, V> map, zzje<K, V> zzje2, zzho zzho2) throws IOException {
        int n;
        this.zzaq(2);
        int n2 = this.zzfe();
        this.zzap(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            int n4;
            Object object = zzje2.zzaaj;
            Object object2 = zzje2.zzgk;
            block9: while ((n4 = this.zzeo()) != Integer.MAX_VALUE) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.zza(zzje2.zzaai, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.zza(zzje2.zzaak, zzje2.zzgk.getClass(), zzho2);
                            continue block9;
                        }
                    }
                    if (this.zzep()) continue;
                    throw new zzin("Unable to parse map entry.");
                }
                catch (zzim zzim2) {
                    if (this.zzep()) continue;
                    throw new zzin("Unable to parse map entry.");
                }
            }
            map.put(object, object2);
            return;
        }
        finally {
            this.limit = n3;
        }
    }

    private final Object zza(zzll zzll2, Class<?> clazz, zzho zzho2) throws IOException {
        switch (zzll2) {
            case zzadp: {
                return this.zzev();
            }
            case zzadt: {
                return this.zzex();
            }
            case zzadi: {
                return this.readDouble();
            }
            case zzadv: {
                return this.zzez();
            }
            case zzado: {
                return this.zzeu();
            }
            case zzadn: {
                return this.zzet();
            }
            case zzadj: {
                return Float.valueOf(this.readFloat());
            }
            case zzadm: {
                return this.zzes();
            }
            case zzadk: {
                return this.zzer();
            }
            case zzads: {
                return this.zza(clazz, zzho2);
            }
            case zzadw: {
                return this.zzfa();
            }
            case zzadx: {
                return this.zzfb();
            }
            case zzady: {
                return this.zzfc();
            }
            case zzadz: {
                return this.zzfd();
            }
            case zzadq: {
                return this.zzj(true);
            }
            case zzadu: {
                return this.zzey();
            }
            case zzadl: {
                return this.zzeq();
            }
        }
        throw new RuntimeException("unsupported field type.");
    }

    private final int zzfe() throws IOException {
        int n;
        int n2 = this.pos;
        if (this.limit == this.pos) {
            throw zzin.zzhh();
        }
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return (int)this.zzfg();
        }
        if ((n ^= this.buffer[n2++] << 7) < 0) {
            n ^= 0xFFFFFF80;
        } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
            n ^= 0x3F80;
        } else if ((n ^= this.buffer[n2++] << 21) < 0) {
            n ^= 0xFFE03F80;
        } else {
            byte by = this.buffer[n2++];
            n = n ^ by << 28 ^ 0xFE03F80;
            if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                throw zzin.zzhj();
            }
        }
        this.pos = n2;
        return n;
    }

    private final long zzff() throws IOException {
        long l;
        int n;
        int n2 = this.pos;
        if (this.limit == n2) {
            throw zzin.zzhh();
        }
        byte[] byArray = this.buffer;
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return this.zzfg();
        }
        if ((n ^= byArray[n2++] << 7) < 0) {
            l = n ^ 0xFFFFFF80;
        } else if ((n ^= byArray[n2++] << 14) >= 0) {
            l = n ^ 0x3F80;
        } else if ((n ^= byArray[n2++] << 21) < 0) {
            l = n ^ 0xFFE03F80;
        } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
            l ^= 0xFE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
            l ^= 0xFFFFFFF80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
            l ^= 0x3F80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
            l ^= 0xFFFE03F80FE03F80L;
        } else if ((l = l ^ (long)byArray[n2++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
            throw zzin.zzhj();
        }
        this.pos = n2;
        return l;
    }

    private final long zzfg() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzin.zzhj();
    }

    private final byte readByte() throws IOException {
        if (this.pos == this.limit) {
            throw zzin.zzhh();
        }
        return this.buffer[this.pos++];
    }

    private final int zzfh() throws IOException {
        this.zzap(4);
        return this.zzfj();
    }

    private final long zzfi() throws IOException {
        this.zzap(8);
        return this.zzfk();
    }

    private final int zzfj() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzfk() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private final void zzao(int n) throws IOException {
        this.zzap(n);
        this.pos += n;
    }

    private final void zzap(int n) throws IOException {
        if (n < 0 || n > this.limit - this.pos) {
            throw zzin.zzhh();
        }
    }

    private final void zzaq(int n) throws IOException {
        if ((this.tag & 7) != n) {
            throw zzin.zzhm();
        }
    }

    private final void zzar(int n) throws IOException {
        this.zzap(n);
        if ((n & 7) != 0) {
            throw zzin.zzhn();
        }
    }

    private final void zzas(int n) throws IOException {
        this.zzap(n);
        if ((n & 3) != 0) {
            throw zzin.zzhn();
        }
    }

    private final void zzat(int n) throws IOException {
        if (this.pos != n) {
            throw zzin.zzhh();
        }
    }
}

