/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.vision.zzaw;
import com.google.android.gms.internal.vision.zzax;
import com.google.android.gms.internal.vision.zzay;
import com.google.android.gms.internal.vision.zzaz;
import com.google.android.gms.internal.vision.zzbb;
import com.google.android.gms.internal.vision.zzbi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzau
implements zzay {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzau> zzfp = new ArrayMap();
    private final ContentResolver zzfq;
    private final Uri uri;
    private final ContentObserver zzfr = new zzaw(this, null);
    private final Object zzfs = new Object();
    private volatile Map<String, String> zzft;
    @GuardedBy(value="this")
    private final List<zzaz> zzfu = new ArrayList<zzaz>();
    private static final String[] zzfv = new String[]{"key", "value"};

    private zzau(ContentResolver contentResolver, Uri uri) {
        this.zzfq = contentResolver;
        this.uri = uri;
        contentResolver.registerContentObserver(uri, false, this.zzfr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzau zza(ContentResolver contentResolver, Uri uri) {
        Class<zzau> clazz = zzau.class;
        synchronized (zzau.class) {
            zzau zzau2 = zzfp.get(uri);
            if (zzau2 == null) {
                try {
                    zzau2 = new zzau(contentResolver, uri);
                    zzfp.put(uri, zzau2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzau2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> zzv() {
        Map<String, String> map = this.zzft;
        if (map == null) {
            Object object = this.zzfs;
            synchronized (object) {
                map = this.zzft;
                if (map == null) {
                    this.zzft = map = this.zzx();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzw() {
        zzau zzau2;
        Object object = this.zzfs;
        synchronized (object) {
            this.zzft = null;
            zzbi.zzaf();
        }
        zzau zzau3 = zzau2 = this;
        synchronized (zzau2) {
            Iterator<zzaz> iterator = zzau2.zzfu.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzad();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zzx() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzbb.zza(new zzax(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzy() {
        for (zzau zzau2 : zzfp.values()) {
            zzau2.zzfq.unregisterContentObserver(zzau2.zzfr);
        }
        zzfp.clear();
    }

    @Override
    public final /* synthetic */ Object zzb(String string) {
        String string2 = string;
        return this.zzv().get(string2);
    }

    final /* synthetic */ Map zzz() {
        Cursor cursor = this.zzfq.query(this.uri, zzfv, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

