/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzao = new Metadata();
    private ByteBuffer zzap = null;
    private Bitmap zzaq = null;

    public Metadata getMetadata() {
        return this.zzao;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.zzaq != null) {
            Frame frame = this;
            int n = frame.zzaq.getWidth();
            int n2 = frame.zzaq.getHeight();
            int[] nArray = new int[n * n2];
            frame.zzaq.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzap;
    }

    public Bitmap getBitmap() {
        return this.zzaq;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    public static class Metadata {
        private int width;
        private int height;
        private int id;
        private long zzar;
        private int rotation;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.width = metadata.getWidth();
            this.height = metadata.getHeight();
            this.id = metadata.getId();
            this.zzar = metadata.getTimestampMillis();
            this.rotation = metadata.getRotation();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getId() {
            return this.id;
        }

        public long getTimestampMillis() {
            return this.zzar;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getFormat() {
            return this.format;
        }

        public final void zzd() {
            if (this.rotation % 2 != 0) {
                int n = this.width;
                this.width = this.height;
                this.height = n;
            }
            this.rotation = 0;
        }
    }

    public static class Builder {
        private Frame zzas = new Frame(null);

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzas.zzaq = bitmap;
            Metadata metadata = this.zzas.getMetadata();
            metadata.width = n;
            metadata.height = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzas.zzap = byteBuffer;
            Metadata metadata = this.zzas.getMetadata();
            metadata.width = n;
            metadata.height = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzas.getMetadata().id = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzas.getMetadata().zzar = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzas.getMetadata().rotation = n;
            return this;
        }

        public Frame build() {
            if (this.zzas.zzap == null && this.zzas.zzaq == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzas;
        }
    }
}

