/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzr;
    private Tracker<T> zzak;
    private int zzal = 3;
    private boolean zzam = false;
    private int zzan;
    private int zzao = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzr = detector;
        this.zzak = tracker;
    }

    @Override
    public void release() {
        this.zzak.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzao == this.zzal) {
                this.zzak.onDone();
                this.zzam = false;
            } else {
                this.zzak.onMissing(detections);
            }
            ++this.zzao;
            return;
        }
        this.zzao = 0;
        if (this.zzam) {
            Object object2 = sparseArray.get(this.zzan);
            if (object2 != null) {
                this.zzak.onUpdate(detections, object2);
                return;
            }
            this.zzak.onDone();
            this.zzam = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzam = true;
        this.zzan = n;
        this.zzr.setFocus(this.zzan);
        this.zzak.onNewItem(this.zzan, object);
        this.zzak.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zza(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzal = n;
    }
}

