/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamite.DynamiteModule;
import javax.annotation.concurrent.GuardedBy;

public abstract class zzm<T> {
    private static String PREFIX = "com.google.android.gms.vision.dynamite";
    private final Context zze;
    private final Object lock = new Object();
    private final String tag;
    private final String zzdh;
    private final String zzdi;
    private boolean zzdj = false;
    @GuardedBy(value="lock")
    private T zzdk;

    public zzm(Context context, String string, String string2) {
        this.zze = context;
        this.tag = string;
        String string3 = PREFIX;
        this.zzdh = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(".").append(string2).toString();
        this.zzdi = PREFIX;
    }

    public final boolean isOperational() {
        return this.zzq() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzp() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdk == null) {
                return;
            }
            try {
                this.zzm();
            }
            catch (RemoteException remoteException) {
                Log.e((String)this.tag, (String)"Could not finalize native handle", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T zzq() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdk != null) {
                return this.zzdk;
            }
            try {
                DynamiteModule dynamiteModule = null;
                try {
                    dynamiteModule = DynamiteModule.load((Context)this.zze, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)this.zzdh);
                }
                catch (DynamiteModule.LoadingException loadingException) {
                    Log.d((String)this.tag, (String)"Cannot load feature, fall back to load whole module.");
                    try {
                        dynamiteModule = DynamiteModule.load((Context)this.zze, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)this.zzdi);
                    }
                    catch (DynamiteModule.LoadingException loadingException2) {
                        Log.e((String)this.tag, (String)"Error Loading module", (Throwable)loadingException2);
                    }
                }
                if (dynamiteModule != null) {
                    this.zzdk = this.zza(dynamiteModule, this.zze);
                }
            }
            catch (RemoteException | DynamiteModule.LoadingException throwable) {
                Log.e((String)this.tag, (String)"Error creating remote native handle", (Throwable)throwable);
            }
            if (!this.zzdj && this.zzdk == null) {
                Log.w((String)this.tag, (String)"Native handle not yet available. Reverting to no-op handle.");
                this.zzdj = true;
            } else if (this.zzdj && this.zzdk != null) {
                Log.w((String)this.tag, (String)"Native handle is now available.");
            }
            return this.zzdk;
        }
    }

    protected abstract T zza(DynamiteModule var1, Context var2) throws RemoteException, DynamiteModule.LoadingException;

    protected abstract void zzm() throws RemoteException;
}

