/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzez;
import com.google.android.gms.internal.vision.zzfk;
import com.google.android.gms.internal.vision.zzfy;
import com.google.android.gms.internal.vision.zzgf;
import com.google.android.gms.internal.vision.zzhq;
import com.google.android.gms.internal.vision.zzjr;
import com.google.android.gms.internal.vision.zzjs;
import com.google.android.gms.internal.vision.zzjt;
import com.google.android.gms.internal.vision.zzjw;
import java.io.IOException;

public final class zzjk {
    private final byte[] buffer;
    private final int zzacz;
    private final int zzada;
    private int zzadb;
    private int zzsl;
    private int zzadc;
    private int zzsn;
    private int zzso = Integer.MAX_VALUE;
    private int zzsf;
    private int zzsg = 64;
    private int zzsh = 0x4000000;
    private zzez zzadd;

    public static zzjk zzk(byte[] byArray, int n, int n2) {
        return new zzjk(byArray, 0, n2);
    }

    public final int zzdq() throws IOException {
        zzjk zzjk2 = this;
        if (zzjk2.zzadc == zzjk2.zzadb) {
            this.zzsn = 0;
            return 0;
        }
        this.zzsn = this.zzdt();
        if (this.zzsn == 0) {
            throw new zzjs("Protocol message contained an invalid tag (zero).");
        }
        return this.zzsn;
    }

    public final void zzak(int n) throws zzjs {
        if (this.zzsn != n) {
            throw new zzjs("Protocol message end-group tag did not match expected tag.");
        }
    }

    public final boolean zzal(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                this.zzdt();
                return true;
            }
            case 1: {
                zzjk zzjk2 = this;
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                zzjk2.zzdy();
                return true;
            }
            case 2: {
                this.zzap(this.zzdt());
                return true;
            }
            case 3: {
                int n2;
                zzjk zzjk3 = this;
                while ((n2 = zzjk3.zzdq()) != 0 && zzjk3.zzal(n2)) {
                }
                this.zzak(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.zzdv();
                return true;
            }
        }
        throw new zzjs("Protocol message tag had invalid wire type.");
    }

    public final boolean zzcu() throws IOException {
        return this.zzdt() != 0;
    }

    public final String readString() throws IOException {
        int n = this.zzdt();
        if (n < 0) {
            throw zzjs.zzhu();
        }
        if (n > this.zzadb - this.zzadc) {
            throw zzjs.zzht();
        }
        String string = new String(this.buffer, this.zzadc, n, zzjr.UTF_8);
        this.zzadc += n;
        return string;
    }

    public final void zza(zzjt zzjt2) throws IOException {
        int n = this.zzdt();
        if (this.zzsf >= this.zzsg) {
            throw new zzjs("Protocol message had too many levels of nesting.  May be malicious.  Use CodedInputStream.setRecursionLimit() to increase the depth limit.");
        }
        int n2 = this.zzan(n);
        ++this.zzsf;
        zzjt2.zza(this);
        this.zzak(0);
        --this.zzsf;
        this.zzao(n2);
    }

    public final int zzdt() throws IOException {
        byte by = this.zzdy();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.zzdy();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.zzdy();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.zzdy();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    int n2 = n | (by & 0x7F) << 21;
                    by = this.zzdy();
                    n = n2 | by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.zzdy() < 0) continue;
                            return n;
                        }
                        throw zzjs.zzhv();
                    }
                }
            }
        }
        return n;
    }

    public final long zzdu() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzdy();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzjs.zzhv();
    }

    public final int zzdv() throws IOException {
        byte by = this.zzdy();
        byte by2 = this.zzdy();
        byte by3 = this.zzdy();
        byte by4 = this.zzdy();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    private zzjk(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.zzacz = n;
        this.zzada = this.zzadb = n + n2;
        this.zzadc = n;
    }

    public final <T extends zzfy<T, ?>> T zza(zzhq<T> zzhq2) throws IOException {
        try {
            int n;
            int n2;
            zzjk zzjk2 = this;
            if (zzjk2.zzadd == null) {
                zzjk2.zzadd = zzez.zze(zzjk2.buffer, zzjk2.zzacz, zzjk2.zzada);
            }
            if ((n2 = zzjk2.zzadd.zzds()) > (n = zzjk2.zzadc - zzjk2.zzacz)) {
                throw new IOException(String.format("CodedInputStream read ahead of CodedInputByteBufferNano: %s > %s", n2, n));
            }
            zzjk2.zzadd.zzap(n - n2);
            zzjk2.zzadd.zzam(zzjk2.zzsg - zzjk2.zzsf);
            zzfy zzfy2 = (zzfy)zzjk2.zzadd.zza(zzhq2, zzfk.zzel());
            this.zzal(this.zzsn);
            return (T)zzfy2;
        }
        catch (zzgf zzgf2) {
            throw new zzjs("", zzgf2);
        }
    }

    public final int zzan(int n) throws zzjs {
        if (n < 0) {
            throw zzjs.zzhu();
        }
        int n2 = this.zzso;
        if ((n += this.zzadc) > n2) {
            throw zzjs.zzht();
        }
        this.zzso = n;
        this.zzdx();
        return n2;
    }

    private final void zzdx() {
        this.zzadb += this.zzsl;
        int n = this.zzadb;
        if (n > this.zzso) {
            this.zzsl = n - this.zzso;
            this.zzadb -= this.zzsl;
            return;
        }
        this.zzsl = 0;
    }

    public final void zzao(int n) {
        this.zzso = n;
        this.zzdx();
    }

    public final int zzhq() {
        if (this.zzso == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.zzadc;
        return this.zzso - n;
    }

    public final int getPosition() {
        return this.zzadc - this.zzacz;
    }

    public final byte[] zzv(int n, int n2) {
        if (n2 == 0) {
            return zzjw.zzaea;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.zzacz + n;
        System.arraycopy(this.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public final void zzbt(int n) {
        this.zzw(n, this.zzsn);
    }

    final void zzw(int n, int n2) {
        if (n > this.zzadc - this.zzacz) {
            int n3 = this.zzadc - this.zzacz;
            throw new IllegalArgumentException(new StringBuilder(50).append("Position ").append(n).append(" is beyond current ").append(n3).toString());
        }
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad position ").append(n).toString());
        }
        this.zzadc = this.zzacz + n;
        this.zzsn = n2;
    }

    private final byte zzdy() throws IOException {
        if (this.zzadc == this.zzadb) {
            throw zzjs.zzht();
        }
        return this.buffer[this.zzadc++];
    }

    private final void zzap(int n) throws IOException {
        if (n < 0) {
            throw zzjs.zzhu();
        }
        if (this.zzadc + n > this.zzso) {
            this.zzap(this.zzso - this.zzadc);
            throw zzjs.zzht();
        }
        if (n <= this.zzadb - this.zzadc) {
            this.zzadc += n;
            return;
        }
        throw zzjs.zzht();
    }
}

