/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzcw;
import com.google.android.gms.internal.vision.zzej;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcd
extends zzbi<Double>
implements zzcw<Double>,
zzej,
RandomAccess {
    private static final zzcd zzhl = new zzcd();
    private double[] zzhm;
    private int size;

    zzcd() {
        this(new double[10], 0);
    }

    private zzcd(double[] dArray, int n) {
        this.zzhm = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzap();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhm, n2, this.zzhm, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcd)) {
            return super.equals(object);
        }
        zzcd zzcd2 = (zzcd)object;
        if (this.size != zzcd2.size) {
            return false;
        }
        double[] dArray = zzcd2.zzhm;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhm[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhm[i]);
            n = n * 31 + zzct.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzap();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
        if (this.size < this.zzhm.length) {
            System.arraycopy(this.zzhm, n, this.zzhm, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhm, 0, dArray, 0, n);
            System.arraycopy(this.zzhm, n, dArray, n + 1, this.size - n);
            this.zzhm = dArray;
        }
        this.zzhm[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzap();
        zzct.checkNotNull(collection);
        if (!(collection instanceof zzcd)) {
            return super.addAll(collection);
        }
        zzcd zzcd2 = (zzcd)collection;
        if (zzcd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcd2.size;
        if (n > this.zzhm.length) {
            this.zzhm = Arrays.copyOf(this.zzhm, n);
        }
        System.arraycopy(zzcd2.zzhm, 0, this.zzhm, this.size, zzcd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzap();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhm[i])) continue;
            System.arraycopy(this.zzhm, i + 1, this.zzhm, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzi(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
    }

    private final String zzj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzcd zzcd2 = this;
        zzcd2.zzap();
        zzcd2.zzi(n);
        double d3 = zzcd2.zzhm[n];
        zzcd2.zzhm[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcd zzcd2 = this;
        zzcd2.zzap();
        zzcd2.zzi(n);
        double d = zzcd2.zzhm[n];
        if (n < zzcd2.size - 1) {
            System.arraycopy(zzcd2.zzhm, n + 1, zzcd2.zzhm, n, zzcd2.size - n);
        }
        --zzcd2.size;
        ++zzcd2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzcw zzk(int n) {
        int n2 = n;
        zzcd zzcd2 = this;
        if (n2 < zzcd2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcd(Arrays.copyOf(zzcd2.zzhm, n2), zzcd2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzcd zzcd2 = this;
        zzcd2.zzi(n);
        return zzcd2.zzhm[n];
    }

    static {
        zzhl.zzao();
    }
}

