/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import javax.annotation.concurrent.GuardedBy;

public abstract class Detector<T> {
    private final Object zzad = new Object();
    @GuardedBy(value="processorLock")
    private Processor<T> zzae;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzad;
        synchronized (object) {
            if (this.zzae != null) {
                this.zzae.release();
                this.zzae = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zzd();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zzad;
        synchronized (object) {
            if (detector.zzae == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzae.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zzad;
        synchronized (object) {
            if (this.zzae != null) {
                this.zzae.release();
            }
            this.zzae = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zzaf;
        private final Frame.Metadata zzag;
        private final boolean zzah;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzaf = sparseArray;
            this.zzag = metadata;
            this.zzah = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzaf;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzag;
        }

        public boolean detectorIsOperational() {
            return this.zzah;
        }
    }
}

