/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context zze;
    private final Object zzf = new Object();
    @GuardedBy(value="cameraLock")
    private Camera zzg;
    private int facing = 0;
    private int rotation;
    private Size zzh;
    private float zzi = 30.0f;
    private int zzj = 1024;
    private int zzk = 768;
    private boolean zzl = false;
    private SurfaceTexture zzm;
    private boolean zzn;
    private Thread zzo;
    private zzb zzp;
    private Map<byte[], ByteBuffer> zzq = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzf;
        synchronized (object) {
            this.stop();
            this.zzp.release();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzf;
        synchronized (object) {
            if (this.zzg != null) {
                return this;
            }
            this.zzg = this.zza();
            this.zzm = new SurfaceTexture(100);
            this.zzg.setPreviewTexture(this.zzm);
            this.zzn = true;
            this.zzg.startPreview();
            this.zzo = new Thread(this.zzp);
            this.zzp.setActive(true);
            this.zzo.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzf;
        synchronized (object) {
            if (this.zzg != null) {
                return this;
            }
            this.zzg = this.zza();
            this.zzg.setPreviewDisplay(surfaceHolder);
            this.zzg.startPreview();
            this.zzo = new Thread(this.zzp);
            this.zzp.setActive(true);
            this.zzo.start();
            this.zzn = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzf;
        synchronized (object) {
            this.zzp.setActive(false);
            if (this.zzo != null) {
                try {
                    this.zzo.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzo = null;
            }
            if (this.zzg != null) {
                this.zzg.stopPreview();
                this.zzg.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzn) {
                        this.zzg.setPreviewTexture(null);
                    } else {
                        this.zzg.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.zzg.release();
                this.zzg = null;
            }
            this.zzq.clear();
            return;
        }
    }

    public Size getPreviewSize() {
        return this.zzh;
    }

    public int getCameraFacing() {
        return this.facing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.zzf;
        synchronized (object) {
            if (this.zzg != null) {
                zzd zzd2 = new zzd(null);
                zzd2.zzaa = shutterCallback;
                zzc zzc2 = new zzc(null);
                zzc2.zzz = pictureCallback;
                this.zzg.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
            return;
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private final Camera zza() throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        block22: {
            int n6 = this.facing;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (n5 = 0; n5 < Camera.getNumberOfCameras(); ++n5) {
                Camera.getCameraInfo((int)n5, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n6) continue;
                n4 = n5;
                break block22;
            }
            n4 = n3 = -1;
        }
        if (n4 == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n3);
        n5 = this.zzk;
        int n7 = this.zzj;
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block7: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block7;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        Object object2 = arrayList;
        zze zze2 = null;
        int n8 = Integer.MAX_VALUE;
        ArrayList<zze> arrayList2 = object2;
        int n9 = arrayList2.size();
        Iterator iterator = null;
        for (int i = 0; i < n9; ++i) {
            Object e = arrayList2.get(i);
            object = (zze)e;
            Size size = ((zze)object).zzb();
            n2 = Math.abs(size.getWidth() - n7) + Math.abs(size.getHeight() - n5);
            if (n2 >= n8) continue;
            zze2 = object;
            n8 = n2;
        }
        zze zze3 = zze2;
        if (zze3 == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size size = zze3.zzc();
        this.zzh = zze3.zzb();
        float f = this.zzi;
        Object object3 = camera;
        n5 = (int)(f * 1000.0f);
        object2 = null;
        int n10 = Integer.MAX_VALUE;
        iterator = object3.getParameters().getSupportedPreviewFpsRange().iterator();
        while (iterator.hasNext()) {
            object = (int[])iterator.next();
            int n11 = n5 - object[0];
            n2 = n5 - object[1];
            int n12 = Math.abs(n11) + Math.abs(n2);
            if (n12 >= n10) continue;
            object2 = object;
            n10 = n12;
        }
        Object object4 = object2;
        if (object4 == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters2 = camera.getParameters();
        if (size != null) {
            parameters2.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters2.setPreviewSize(this.zzh.getWidth(), this.zzh.getHeight());
        parameters2.setPreviewFpsRange(object4[0], object4[1]);
        parameters2.setPreviewFormat(17);
        int n13 = n3;
        Camera.Parameters parameters3 = parameters2;
        Camera camera2 = camera;
        object3 = this;
        WindowManager windowManager = (WindowManager)object3.zze.getSystemService("window");
        n8 = 0;
        int n14 = windowManager.getDefaultDisplay().getRotation();
        switch (n14) {
            case 0: {
                n8 = 0;
                break;
            }
            case 1: {
                n8 = 90;
                break;
            }
            case 2: {
                n8 = 180;
                break;
            }
            case 3: {
                n8 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n14).toString());
            }
        }
        object = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n13, (Camera.CameraInfo)object);
        if (((Camera.CameraInfo)object).facing == 1) {
            n = (((Camera.CameraInfo)object).orientation + n8) % 360;
            n2 = (360 - n) % 360;
        } else {
            n2 = n = (((Camera.CameraInfo)object).orientation - n8 + 360) % 360;
        }
        object3.rotation = n / 90;
        camera2.setDisplayOrientation(n2);
        parameters3.setRotation(n);
        if (this.zzl) {
            if (parameters2.getSupportedFocusModes().contains("continuous-video")) {
                parameters2.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters2);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza(null));
        camera.addCallbackBuffer(this.zza(this.zzh));
        camera.addCallbackBuffer(this.zza(this.zzh));
        camera.addCallbackBuffer(this.zza(this.zzh));
        camera.addCallbackBuffer(this.zza(this.zzh));
        return camera;
    }

    @SuppressLint(value={"InlinedApi"})
    private final byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        byte[] byArray = new byte[(int)Math.ceil((double)(size.getHeight() * size.getWidth() * n) / 8.0) + 1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzq.put(byArray, byteBuffer);
        return byArray;
    }

    /* synthetic */ CameraSource(com.google.android.gms.vision.zza zza2) {
        this();
    }

    final class zzb
    implements Runnable {
        private Detector<?> zzr;
        private long zzu = SystemClock.elapsedRealtime();
        private final Object lock = new Object();
        private boolean zzv = true;
        private long zzw;
        private int zzx = 0;
        private ByteBuffer zzy;

        zzb(Detector<?> detector) {
            this.zzr = detector;
        }

        @SuppressLint(value={"Assert"})
        final void release() {
            this.zzr.release();
            this.zzr = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setActive(boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                this.zzv = bl;
                this.lock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(byte[] byArray, Camera camera) {
            Object object = this.lock;
            synchronized (object) {
                if (this.zzy != null) {
                    camera.addCallbackBuffer(this.zzy.array());
                    this.zzy = null;
                }
                if (!CameraSource.this.zzq.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zzw = SystemClock.elapsedRealtime() - this.zzu;
                ++this.zzx;
                this.zzy = (ByteBuffer)CameraSource.this.zzq.get(byArray);
                this.lock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public final void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.lock;
                synchronized (object) {
                    while (this.zzv && this.zzy == null) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzv) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzy, CameraSource.this.zzh.getWidth(), CameraSource.this.zzh.getHeight(), 17).setId(this.zzx).setTimestampMillis(this.zzw).setRotation(CameraSource.this.rotation).build();
                    byteBuffer = this.zzy;
                    this.zzy = null;
                }
                try {
                    this.zzr.receiveFrame(frame);
                    continue;
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)exception);
                    continue;
                }
                finally {
                    CameraSource.this.zzg.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    final class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public final void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.zzp.zza(byArray, camera);
        }

        /* synthetic */ zza(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zze {
        private Size zzab;
        private Size zzac;

        public zze(Camera.Size size, @Nullable Camera.Size size2) {
            this.zzab = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzac = new Size(size2.width, size2.height);
            }
        }

        public final Size zzb() {
            return this.zzab;
        }

        @Nullable
        public final Size zzc() {
            return this.zzac;
        }
    }

    final class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzz;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zzz != null) {
                this.zzz.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.zzf;
            synchronized (object) {
                if (CameraSource.this.zzg != null) {
                    CameraSource.this.zzg.startPreview();
                }
                return;
            }
        }

        /* synthetic */ zzc(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    static final class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzaa;

        private zzd() {
        }

        public final void onShutter() {
            if (this.zzaa != null) {
                this.zzaa.onShutter();
            }
        }

        /* synthetic */ zzd(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzr;
        private CameraSource zzs = new CameraSource(null);

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzr = detector;
            this.zzs.zze = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzs.zzi = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzs.zzj = n;
            this.zzs.zzk = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzs.facing = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzs.zzl = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzs;
            cameraSource.getClass();
            this.zzs.zzp = cameraSource.new zzb(this.zzr);
            return this.zzs;
        }
    }
}

