/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzcw;
import com.google.android.gms.internal.vision.zzej;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdl
extends zzbi<Long>
implements zzcw<Long>,
zzej,
RandomAccess {
    private static final zzdl zzmr = new zzdl();
    private long[] zzms;
    private int size;

    zzdl() {
        this(new long[10], 0);
    }

    private zzdl(long[] lArray, int n) {
        this.zzms = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzap();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzms, n2, this.zzms, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdl)) {
            return super.equals(object);
        }
        zzdl zzdl2 = (zzdl)object;
        if (this.size != zzdl2.size) {
            return false;
        }
        long[] lArray = zzdl2.zzms;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzms[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzct.zzk(this.zzms[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzi(n);
        return this.zzms[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzl(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzap();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
        if (this.size < this.zzms.length) {
            System.arraycopy(this.zzms, n, this.zzms, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzms, 0, lArray, 0, n);
            System.arraycopy(this.zzms, n, lArray, n + 1, this.size - n);
            this.zzms = lArray;
        }
        this.zzms[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzap();
        zzct.checkNotNull(collection);
        if (!(collection instanceof zzdl)) {
            return super.addAll(collection);
        }
        zzdl zzdl2 = (zzdl)collection;
        if (zzdl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdl2.size;
        if (n > this.zzms.length) {
            this.zzms = Arrays.copyOf(this.zzms, n);
        }
        System.arraycopy(zzdl2.zzms, 0, this.zzms, this.size, zzdl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzap();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzms[i])) continue;
            System.arraycopy(this.zzms, i + 1, this.zzms, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzi(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
    }

    private final String zzj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdl zzdl2 = this;
        zzdl2.zzap();
        zzdl2.zzi(n);
        long l3 = zzdl2.zzms[n];
        zzdl2.zzms[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdl zzdl2 = this;
        zzdl2.zzap();
        zzdl2.zzi(n);
        long l = zzdl2.zzms[n];
        if (n < zzdl2.size - 1) {
            System.arraycopy(zzdl2.zzms, n + 1, zzdl2.zzms, n, zzdl2.size - n);
        }
        --zzdl2.size;
        ++zzdl2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzcw zzk(int n) {
        int n2 = n;
        zzdl zzdl2 = this;
        if (n2 < zzdl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdl(Arrays.copyOf(zzdl2.zzms, n2), zzdl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzmr.zzao();
    }
}

