/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzlew = new Object();
    private Camera zzlex;
    private int zzley = 0;
    private int zzcma;
    private Size zzlez;
    private float zzlfa = 30.0f;
    private int zzlfb = 1024;
    private int zzlfc = 768;
    private boolean zzlfd = false;
    private SurfaceTexture zzlfe;
    private boolean zzlff;
    private Thread zzlfg;
    private zzb zzlfh;
    private Map<byte[], ByteBuffer> zzlfi = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzlew;
        synchronized (object) {
            this.stop();
            this.zzlfh.release();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzlew;
        synchronized (object) {
            if (this.zzlex != null) {
                return this;
            }
            this.zzlex = this.zzblh();
            this.zzlfe = new SurfaceTexture(100);
            this.zzlex.setPreviewTexture(this.zzlfe);
            this.zzlff = true;
            this.zzlex.startPreview();
            this.zzlfg = new Thread(this.zzlfh);
            this.zzlfh.setActive(true);
            this.zzlfg.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzlew;
        synchronized (object) {
            if (this.zzlex != null) {
                return this;
            }
            this.zzlex = this.zzblh();
            this.zzlex.setPreviewDisplay(surfaceHolder);
            this.zzlex.startPreview();
            this.zzlfg = new Thread(this.zzlfh);
            this.zzlfh.setActive(true);
            this.zzlfg.start();
            this.zzlff = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzlew;
        synchronized (object) {
            this.zzlfh.setActive(false);
            if (this.zzlfg != null) {
                try {
                    this.zzlfg.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzlfg = null;
            }
            if (this.zzlex != null) {
                this.zzlex.stopPreview();
                this.zzlex.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzlff) {
                        this.zzlex.setPreviewTexture(null);
                    } else {
                        this.zzlex.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.zzlex.release();
                this.zzlex = null;
            }
            this.zzlfi.clear();
            return;
        }
    }

    public Size getPreviewSize() {
        return this.zzlez;
    }

    public int getCameraFacing() {
        return this.zzley;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.zzlew;
        synchronized (object) {
            if (this.zzlex != null) {
                zzd zzd2 = new zzd(null);
                zzd2.zzlfq = shutterCallback;
                zzc zzc2 = new zzc(this, null);
                zzc2.zzlfp = pictureCallback;
                this.zzlex.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
            return;
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private final Camera zzblh() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Camera.CameraInfo cameraInfo;
        block16: {
            int n5 = this.zzley;
            cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n5) continue;
                n4 = i;
                break block16;
            }
            n4 = n3 = -1;
        }
        if (n4 == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n3);
        zze zze2 = CameraSource.zza(camera, this.zzlfb, this.zzlfc);
        if (zze2 == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size size = zze2.zzblj();
        this.zzlez = zze2.zzbli();
        int[] nArray = CameraSource.zza(camera, this.zzlfa);
        if (nArray == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.zzlez.getWidth(), this.zzlez.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        int n6 = n3;
        Camera.Parameters parameters2 = parameters;
        cameraInfo = camera;
        CameraSource cameraSource = this;
        WindowManager windowManager = (WindowManager)cameraSource.mContext.getSystemService("window");
        int n7 = 0;
        int n8 = windowManager.getDefaultDisplay().getRotation();
        switch (n8) {
            case 0: {
                n7 = 0;
                break;
            }
            case 1: {
                n7 = 90;
                break;
            }
            case 2: {
                n7 = 180;
                break;
            }
            case 3: {
                n7 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n8).toString());
            }
        }
        Camera.CameraInfo cameraInfo2 = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n6, (Camera.CameraInfo)cameraInfo2);
        if (cameraInfo2.facing == 1) {
            n2 = (cameraInfo2.orientation + n7) % 360;
            n = (360 - n2) % 360;
        } else {
            n = n2 = (cameraInfo2.orientation - n7 + 360) % 360;
        }
        cameraSource.zzcma = n2 / 90;
        cameraInfo.setDisplayOrientation(n);
        parameters2.setRotation(n2);
        if (this.zzlfd) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza(this, null));
        camera.addCallbackBuffer(this.zza(this.zzlez));
        camera.addCallbackBuffer(this.zza(this.zzlez));
        camera.addCallbackBuffer(this.zza(this.zzlez));
        camera.addCallbackBuffer(this.zza(this.zzlez));
        return camera;
    }

    private static zze zza(Camera camera, int n, int n2) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        ArrayList<zze> arrayList2 = arrayList;
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        ArrayList<zze> arrayList3 = arrayList2;
        int n4 = arrayList3.size();
        Object var6_19 = null;
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList3.get(i);
            zze zze3 = (zze)e;
            Size size = zze3.zzbli();
            int n5 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n5 >= n3) continue;
            zze2 = zze3;
            n3 = n5;
        }
        return zze2;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        for (int[] nArray2 : camera.getParameters().getSupportedPreviewFpsRange()) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    @SuppressLint(value={"InlinedApi"})
    private final byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        byte[] byArray = new byte[(int)Math.ceil((double)(size.getHeight() * size.getWidth() * n) / 8.0) + 1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzlfi.put(byArray, byteBuffer);
        return byArray;
    }

    /* synthetic */ CameraSource(com.google.android.gms.vision.zza zza2) {
        this();
    }

    final class zzb
    implements Runnable {
        private Detector<?> zzlfj;
        private long zzebf = SystemClock.elapsedRealtime();
        private final Object mLock = new Object();
        private boolean mActive = true;
        private long zzlfm;
        private int zzlfn = 0;
        private ByteBuffer zzlfo;
        private /* synthetic */ CameraSource zzlfl;

        zzb(CameraSource cameraSource, Detector<?> detector) {
            this.zzlfl = cameraSource;
            this.zzlfj = detector;
        }

        @SuppressLint(value={"Assert"})
        final void release() {
            this.zzlfj.release();
            this.zzlfj = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setActive(boolean bl) {
            Object object = this.mLock;
            synchronized (object) {
                this.mActive = bl;
                this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(byte[] byArray, Camera camera) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzlfo != null) {
                    camera.addCallbackBuffer(this.zzlfo.array());
                    this.zzlfo = null;
                }
                if (!this.zzlfl.zzlfi.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zzlfm = SystemClock.elapsedRealtime() - this.zzebf;
                ++this.zzlfn;
                this.zzlfo = (ByteBuffer)this.zzlfl.zzlfi.get(byArray);
                this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public final void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.mLock;
                synchronized (object) {
                    while (this.mActive && this.zzlfo == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.mActive) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzlfo, this.zzlfl.zzlez.getWidth(), this.zzlfl.zzlez.getHeight(), 17).setId(this.zzlfn).setTimestampMillis(this.zzlfm).setRotation(this.zzlfl.zzcma).build();
                    byteBuffer = this.zzlfo;
                    this.zzlfo = null;
                }
                try {
                    this.zzlfj.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    this.zzlfl.zzlex.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    final class zza
    implements Camera.PreviewCallback {
        private /* synthetic */ CameraSource zzlfl;

        private zza(CameraSource cameraSource) {
            this.zzlfl = cameraSource;
        }

        public final void onPreviewFrame(byte[] byArray, Camera camera) {
            this.zzlfl.zzlfh.zza(byArray, camera);
        }

        /* synthetic */ zza(CameraSource cameraSource, com.google.android.gms.vision.zza zza2) {
            this(cameraSource);
        }
    }

    static final class zze {
        private Size zzlfr;
        private Size zzlfs;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzlfr = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzlfs = new Size(size2.width, size2.height);
            }
        }

        public final Size zzbli() {
            return this.zzlfr;
        }

        public final Size zzblj() {
            return this.zzlfs;
        }
    }

    final class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzlfp;
        private /* synthetic */ CameraSource zzlfl;

        private zzc(CameraSource cameraSource) {
            this.zzlfl = cameraSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zzlfp != null) {
                this.zzlfp.onPictureTaken(byArray);
            }
            Object object = this.zzlfl.zzlew;
            synchronized (object) {
                if (this.zzlfl.zzlex != null) {
                    this.zzlfl.zzlex.startPreview();
                }
                return;
            }
        }

        /* synthetic */ zzc(CameraSource cameraSource, com.google.android.gms.vision.zza zza2) {
            this(cameraSource);
        }
    }

    static final class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzlfq;

        private zzd() {
        }

        public final void onShutter() {
            if (this.zzlfq != null) {
                this.zzlfq.onShutter();
            }
        }

        /* synthetic */ zzd(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzlfj;
        private CameraSource zzlfk = new CameraSource(null);

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzlfj = detector;
            this.zzlfk.mContext = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzlfk.zzlfa = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzlfk.zzlfb = n;
            this.zzlfk.zzlfc = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzlfk.zzley = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzlfk.zzlfd = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzlfk;
            cameraSource.getClass();
            this.zzlfk.zzlfh = new zzb(cameraSource, this.zzlfj);
            return this.zzlfk;
        }
    }
}

