/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zza = new Metadata();
    private ByteBuffer zzb = null;
    private Bitmap zzc = null;

    public Metadata getMetadata() {
        return this.zza;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.zzc != null) {
            Frame frame = this;
            int n = frame.zzc.getWidth();
            int n2 = frame.zzc.getHeight();
            int[] nArray = new int[n * n2];
            frame.zzc.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzb;
    }

    public Bitmap getBitmap() {
        return this.zzc;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    public static class Metadata {
        private int zza;
        private int zzb;
        private int zzc;
        private long zzd;
        private int zze;
        private int zzf = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zza = metadata.getWidth();
            this.zzb = metadata.getHeight();
            this.zzc = metadata.getId();
            this.zzd = metadata.getTimestampMillis();
            this.zze = metadata.getRotation();
        }

        public int getWidth() {
            return this.zza;
        }

        public int getHeight() {
            return this.zzb;
        }

        public int getId() {
            return this.zzc;
        }

        public long getTimestampMillis() {
            return this.zzd;
        }

        public int getRotation() {
            return this.zze;
        }

        public int getFormat() {
            return this.zzf;
        }

        @Hide
        public final void zza() {
            if (this.zze % 2 != 0) {
                int n = this.zza;
                this.zza = this.zzb;
                this.zzb = n;
            }
            this.zze = 0;
        }
    }

    public static class Builder {
        private Frame zza = new Frame(null);

        public Builder() {
        }

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zza.zzc = bitmap;
            Metadata metadata = this.zza.getMetadata();
            metadata.zza = n;
            metadata.zzb = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zza.zzb = byteBuffer;
            Metadata metadata = this.zza.getMetadata();
            metadata.zza = n;
            metadata.zzb = n2;
            metadata.zzf = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zza.getMetadata().zzc = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zza.getMetadata().zzd = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zza.getMetadata().zze = n;
            return this;
        }

        public Frame build() {
            if (this.zza.zzb == null && this.zza.zzc == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zza;
        }
    }
}

