/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzksp;
    private Tracker<T> zzkte;
    private int zzktf = 3;
    private boolean zzktg = false;
    private int zzkth;
    private int zzkti = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzksp = detector;
        this.zzkte = tracker;
    }

    @Override
    public void release() {
        this.zzkte.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzkti == this.zzktf) {
                this.zzkte.onDone();
                this.zzktg = false;
            } else {
                this.zzkte.onMissing(detections);
            }
            ++this.zzkti;
            return;
        }
        this.zzkti = 0;
        if (this.zzktg) {
            Object object2 = sparseArray.get(this.zzkth);
            if (object2 != null) {
                this.zzkte.onUpdate(detections, object2);
                return;
            }
            this.zzkte.onDone();
            this.zzktg = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzktg = true;
        this.zzkth = n;
        this.zzksp.setFocus(this.zzkth);
        this.zzkte.onNewItem(this.zzkth, object);
        this.zzkte.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zzew(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzktf = n;
    }
}

