/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzksz = new Object();
    private Processor<T> zzkta;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzksz;
        synchronized (object) {
            if (this.zzkta != null) {
                this.zzkta.release();
                this.zzkta = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zzbjf();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zzksz;
        synchronized (object) {
            if (detector.zzkta == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzkta.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zzksz;
        synchronized (object) {
            if (this.zzkta != null) {
                this.zzkta.release();
            }
            this.zzkta = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zzktb;
        private final Frame.Metadata zzktc;
        private final boolean zzktd;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzktb = sparseArray;
            this.zzktc = metadata;
            this.zzktd = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzktb;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzktc;
        }

        public boolean detectorIsOperational() {
            return this.zzktd;
        }
    }
}

