/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzkho = new Object();
    private Processor<T> zzkhp;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzkho;
        synchronized (object) {
            if (this.zzkhp != null) {
                this.zzkhp.release();
                this.zzkhp = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzkho;
        synchronized (object) {
            if (this.zzkhp == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzbim();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzkhp.receiveDetections(detections);
            return;
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzkhp = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzkhq;
        private Frame.Metadata zzkhr;
        private boolean zzkhs;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzkhq = sparseArray;
            this.zzkhr = metadata;
            this.zzkhs = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzkhq;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzkhr;
        }

        public boolean detectorIsOperational() {
            return this.zzkhs;
        }
    }
}

