/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzbMJ = new Object();
    private Processor<T> zzbMK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbMJ;
        synchronized (object) {
            if (this.zzbMK != null) {
                this.zzbMK.release();
                this.zzbMK = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbMJ;
        synchronized (object) {
            if (this.zzbMK == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzDM();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbMK.receiveDetections(detections);
            return;
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbMK = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbML;
        private Frame.Metadata zzbMM;
        private boolean zzbMN;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbML = sparseArray;
            this.zzbMM = metadata;
            this.zzbMN = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbML;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbMM;
        }

        public boolean detectorIsOperational() {
            return this.zzbMN;
        }
    }
}

