/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgp;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzel
extends zzgp {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzej zzd;
    private final zzej zze;
    private final zzej zzf;
    private final zzej zzg;
    private final zzej zzh;
    private final zzej zzi;
    private final zzej zzj;
    private final zzej zzk;
    private final zzej zzl;

    static /* bridge */ /* synthetic */ char zza(zzel zzel2) {
        return zzel2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzel zzel2) {
        return zzel2.zzb;
    }

    public final zzej zzc() {
        return this.zzk;
    }

    public final zzej zzd() {
        return this.zzd;
    }

    public final zzej zze() {
        return this.zzf;
    }

    public final zzej zzh() {
        return this.zze;
    }

    public final zzej zzi() {
        return this.zzj;
    }

    public final zzej zzj() {
        return this.zzl;
    }

    public final zzej zzk() {
        return this.zzg;
    }

    public final zzej zzl() {
        return this.zzi;
    }

    public final zzej zzm() {
        return this.zzh;
    }

    protected static Object zzn(String string) {
        if (string == null) {
            return null;
        }
        zzek zzek2 = new zzek(string);
        return zzek2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        if (string == null) {
            string = "";
        }
        object = zzel.zzp(bl, object);
        object2 = zzel.zzp(bl, object2);
        object3 = zzel.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return object.toString();
            }
            Long l = (Long)object;
            if (Math.abs(l) < 100L) {
                return object.toString();
            }
            String string2 = object.toString().charAt(0) == '-' ? "-" : "";
            object = String.valueOf(Math.abs(l));
            int n2 = ((String)object).length();
            double d = Math.pow(10.0, n2 + -1);
            long l2 = Math.round(d);
            int n3 = ((String)object).length();
            double d2 = Math.pow(10.0, n3);
            long l3 = Math.round(d2 + -1.0);
            StringBuilder stringBuilder2 = new StringBuilder(string2.length() + 43 + string2.length());
            stringBuilder2.append(string2);
            stringBuilder2.append(l2);
            stringBuilder2.append("...");
            stringBuilder2.append(string2);
            stringBuilder2.append(l3);
            return stringBuilder2.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string3 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string3);
            string = zzel.zzy(zzfv.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzek) {
                return zzek.zza((zzek)object);
            }
            if (!bl) return object.toString();
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string4;
            Object object2 = object[i];
            if (((StackTraceElement)object2).isNativeMethod() || (string4 = ((StackTraceElement)object2).getClassName()) == null || !zzel.zzy(string4).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object2);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private static String zzy(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzq() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzs.zzy();
                if (object != null) {
                    this.zzc = this.zzs.zzy();
                } else {
                    object = this.zzs.zzf();
                    this.zzc = ((zzaf)object).zzn();
                }
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void zzr(zzel zzel2, long l) {
        zzel2.zzb = 46000L;
    }

    static /* bridge */ /* synthetic */ void zzs(zzel zzel2, char c) {
        zzel2.zza = c;
    }

    zzel(zzfv object) {
        super((zzfv)object);
        this.zzd = object = new zzej(this, 6, false, false);
        this.zze = object = new zzej(this, 6, true, false);
        this.zzf = object = new zzej(this, 6, false, true);
        this.zzg = object = new zzej(this, 5, false, false);
        this.zzh = object = new zzej(this, 5, true, false);
        this.zzi = object = new zzej(this, 5, false, true);
        this.zzj = object = new zzej(this, 4, false, false);
        this.zzk = object = new zzej(this, 3, false, false);
        this.zzl = object = new zzej(this, 2, false, false);
    }

    protected final void zzt(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzq(), (int)n)) {
            String string2 = zzel.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzq(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzfs zzfs2 = this.zzs.zzo();
            if (zzfs2 == null) {
                Log.println((int)6, (String)this.zzq(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzfs2.zzx()) {
                Log.println((int)6, (String)this.zzq(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzei zzei2 = new zzei(this, n, string, object, object2, object3);
            zzfs2.zzp(zzei2);
            return;
        }
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

