/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzkw;
import com.google.android.gms.internal.measurement.zzmg;
import com.google.android.gms.internal.measurement.zzs;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzkj;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzkk
extends zzgf {
    private static final String[] zzb;
    private static final String[] zzc;
    private SecureRandom zzd;
    private final AtomicLong zze;
    private int zzf;
    private Integer zzg = null;
    public static final /* synthetic */ int zza;

    zzkk(zzfl object) {
        super((zzfl)object);
        this.zze = object = new AtomicLong(0L);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzay() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzx.zzat().zze().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zze.set(l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzd() {
        if (this.zze.get() == 0L) {
            AtomicLong atomicLong = this.zze;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzx.zzax();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zzf;
                this.zzf = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zze;
        synchronized (atomicLong) {
            this.zze.compareAndSet(-1L, 1L);
            return this.zze.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzf() {
        this.zzg();
        if (this.zzd == null) {
            SecureRandom secureRandom;
            this.zzd = secureRandom = new SecureRandom();
        }
        return this.zzd;
    }

    static boolean zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzi(Uri uri) {
        String string;
        String string2;
        String string3;
        if (uri == null) {
            return null;
        }
        try {
            Object object;
            boolean bl = uri.isHierarchical();
            if (bl) {
                string3 = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string = uri.getQueryParameter("utm_medium");
                String string4 = uri.getQueryParameter("gclid");
                object = string3;
                string3 = string2;
                string2 = string;
                string = string4;
            } else {
                object = null;
                string3 = null;
                string2 = null;
                string = null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzge)object).zzx.zzat().zze().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("campaign", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("source", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("medium", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("gclid", string);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_term")))) {
            bundle.putString("term", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_content")))) {
            bundle.putString("content", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("aclid")))) {
            bundle.putString("aclid", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("cp1")))) {
            bundle.putString("cp1", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("anid")))) {
            bundle.putString("anid", (String)object);
        }
        return bundle;
    }

    final boolean zzj(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzx.zzat().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzx.zzat().zzd().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzx.zzat().zzd().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzx.zzat().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzk(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzx.zzat().zzd().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzx.zzat().zzd().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzx.zzat().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzx.zzat().zzd().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzl(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzx.zzat().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzx.zzat().zzd().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzkk.zzar(string2, stringArray) && (stringArray2 == null || !zzkk.zzar(string2, stringArray2))) {
            this.zzx.zzat().zzd().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzm(String string, int n, String string2) {
        if (string2 == null) {
            this.zzx.zzat().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            this.zzx.zzat().zzd().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzn(String string) {
        if (!this.zzk("event", string)) {
            return 2;
        }
        if (!this.zzl("event", zzgi.zza, zzgi.zzb, string)) {
            return 13;
        }
        this.zzx.zzc();
        if (!this.zzm("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzo(String string) {
        if (!this.zzk("user property", string)) {
            return 6;
        }
        if (!this.zzl("user property", zzgk.zza, null, string)) {
            return 15;
        }
        this.zzx.zzc();
        if (!this.zzm("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    final int zzq(String string) {
        if (!this.zzj("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzx.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzr(String string) {
        if (!this.zzk("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzx.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final boolean zzs(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    final boolean zzt(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            if (((String)(object = String.valueOf(object))).codePointCount(0, ((String)object).length()) > n) {
                this.zzx.zzat().zzh().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, ((String)object).length());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzz(String string, String string2, String string3, Bundle bundle, List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzx.zzc();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n2 = bl ? this.zzq(string4) : 0;
                if (n2 == 0) {
                    n2 = this.zzr(string4);
                }
            } else {
                n2 = 0;
            }
            if (n2 != 0) {
                String string5 = n2 == 3 ? string4 : null;
                this.zzI(bundle, n2, string4, string4, string5);
                bundle.remove(string4);
                continue;
            }
            if (this.zzs(bundle.get(string4))) {
                this.zzx.zzat().zzh().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zzD(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                this.zzI(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzkk.zzh(string4) || zzkk.zzar(string4, zzgj.zzd) || ++n <= 0) continue;
            this.zzx.zzat().zzd().zzc("Item cannot contain custom parameters", this.zzx.zzm().zzc(string2), this.zzx.zzm().zzf(bundle));
            zzkk.zzam(bundle, 23);
            bundle.remove(string4);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzA(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzkk.zzan(string)) return true;
            if (!this.zzx.zzq()) return false;
            this.zzx.zzat().zzd().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzei.zzl(string));
            return false;
        }
        zzmg.zzb();
        if (this.zzx.zzc().zzn(null, zzdw.zzah) && !TextUtils.isEmpty((CharSequence)string3)) return true;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzkk.zzan(string2)) {
                return true;
            }
            this.zzx.zzat().zzd().zzb("Invalid admob_app_id. Analytics disabled.", zzei.zzl(string2));
            return false;
        }
        if (!this.zzx.zzq()) return false;
        this.zzx.zzat().zzd().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzB(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzao(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzC(String.valueOf(parcelableArray), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzU((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public final String zzC(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zzD(String object, String string, String string2, Object object2, Bundle bundle, List<String> list, boolean bl, boolean bl2) {
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzge)object3).zzg();
                                    if (!((zzkk)object3).zzs(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzkk.zzar(string2, zzgj.zzc)) {
                                        return 20;
                                    }
                                    zzjb zzjb2 = ((zzkk)object3).zzx.zzy();
                                    ((zzge)zzjb2).zzg();
                                    zzjb2.zzb();
                                    if (zzjb2.zzD() && zzjb2.zzx.zzl().zzZ() < 200900) {
                                        return 25;
                                    }
                                    ((zzge)object3).zzx.zzc();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            ((zzge)object3).zzx.zzat().zzh().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n3);
                            ((zzge)object3).zzx.zzc();
                            if (!bl3) break block23;
                            Parcelable[] parcelableArray = (Parcelable[])object2;
                            if (parcelableArray.length > 200) {
                                bundle.putParcelableArray(string2, Arrays.copyOf(parcelableArray, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object2;
                            if (arrayList.size() > 200) {
                                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, 200));
                                bundle.putParcelableArrayList(string2, arrayList2);
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (((zzge)object3).zzx.zzc().zzn((String)object, zzdw.zzR) && zzkk.zzR(string) || zzkk.zzR(string2)) {
            ((zzge)object3).zzx.zzc();
            n = 256;
        } else {
            ((zzge)object3).zzx.zzc();
            n = 100;
        }
        if (((zzkk)object3).zzt("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzkk)object3).zzz((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    ((zzge)object3).zzx.zzat().zzh().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                    return 4;
                }
                ((zzkk)object3).zzz((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzge)object3).zzx.zzat().zzh();
                Object object3 = e != null ? e.getClass() : "null";
                ((zzeg)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzkk)object3).zzz((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzE(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzx.zzc();
            return this.zzao(256, object, true, true);
        }
        if (zzkk.zzR(string)) {
            this.zzx.zzc();
            n = 256;
            return this.zzao(n, object, false, true);
        }
        this.zzx.zzc();
        n = 100;
        return this.zzao(n, object, false, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final Bundle zzF(String var1_1, String var2_2, Bundle var3_3, List<String> var4_4, boolean var5_5) {
        block12: {
            var9_6 = zzkk.zzar(var2_2, zzgi.zzd);
            var10_7 = new Bundle(var3_3);
            var11_8 = this.zzx.zzc().zzc();
            if (!this.zzx.zzc().zzn(var1_1, zzdw.zzX)) break block12;
            var6_9 = new Set<E>(var3_3.keySet());
lbl6:
            // 2 sources

            while (true) {
                var12_11 = var6_9.iterator();
                var6_10 = 0;
                block1: while (var12_11.hasNext()) {
                    block13: {
                        block14: {
                            var13_17 = (String)var12_11.next();
                            if (var4_4 != null && var4_4.contains(var13_17)) break block13;
                            if (!var5_5) break block14;
                            var7_12 = this.zzq(var13_17);
lbl14:
                            // 2 sources

                            while (true) {
                                if (var7_12 == 0) {
                                    var7_12 = this.zzr(var13_17);
                                }
lbl17:
                                // 4 sources

                                while (true) {
                                    if (var7_12 != 0) {
                                        if (var7_12 == 3) {
                                            var8_15 = var13_17;
lbl21:
                                            // 2 sources

                                            while (true) {
                                                this.zzI(var10_7, var7_12, var13_17, var13_17, var8_15);
                                                var10_7.remove(var13_17);
                                                continue block1;
                                                break;
                                            }
                                        }
                                        var8_15 = null;
                                        ** continue;
                                    }
                                    var8_16 = this.zzD(var1_1, var2_2, var13_17, var3_3.get(var13_17), var10_7, var4_4, var5_5, var9_6);
                                    if (var8_16 == 17) {
                                        this.zzI(var10_7, 17, var13_17, var13_17, false);
lbl30:
                                        // 2 sources

                                        while (zzkk.zzh(var13_17) && ++var6_10 > var11_8) {
                                            var7_13 /* !! */  = new StringBuilder(48);
                                            var7_13 /* !! */ .append("Event can't contain more than ");
                                            var7_13 /* !! */ .append(var11_8);
                                            var7_13 /* !! */ .append(" params");
                                            var7_13 /* !! */  = var7_13 /* !! */ .toString();
                                            this.zzx.zzat().zzd().zzc((String)var7_13 /* !! */ , this.zzx.zzm().zzc(var2_2), this.zzx.zzm().zzf(var3_3));
                                            zzkk.zzam(var10_7, 5);
                                            var10_7.remove(var13_17);
                                            continue block1;
                                        }
                                        continue block1;
                                    }
                                    if (var8_16 == 0 || "_ev".equals(var13_17)) ** GOTO lbl30
                                    if (var8_16 == 21) {
                                        var7_14 = var2_2;
lbl48:
                                        // 2 sources

                                        while (true) {
                                            this.zzI(var10_7, var8_16, var7_14, var13_17, var3_3.get(var13_17));
                                            var10_7.remove(var13_17);
                                            continue block1;
                                            break;
                                        }
                                    }
                                    var7_14 = var13_17;
                                    ** continue;
                                    break;
                                }
                                break;
                            }
                        }
                        var7_12 = 0;
                        ** continue;
                    }
                    var7_12 = 0;
                    ** continue;
                }
                return var10_7;
            }
        }
        var6_9 = var3_3.keySet();
        ** while (true)
    }

    final void zzG(zzej zzej2, int n) {
        TreeSet treeSet = new TreeSet(zzej2.zzd.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzkk.zzh(string) || ++n2 <= n) continue;
            CharSequence charSequence = new StringBuilder(48);
            charSequence.append("Event can't contain more than ");
            charSequence.append(n);
            charSequence.append(" params");
            charSequence = charSequence.toString();
            this.zzx.zzat().zzd().zzc((String)charSequence, this.zzx.zzm().zzc(zzej2.zza), this.zzx.zzm().zzf(zzej2.zzd));
            zzkk.zzam(zzej2.zzd, 5);
            zzej2.zzd.remove(string);
        }
    }

    final void zzH(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            this.zzx.zzl().zzL(bundle, string, bundle2.get(string));
        }
    }

    final void zzI(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzkk.zzam(bundle, n)) {
            this.zzx.zzc();
            bundle.putString("_ev", this.zzC(string, 40, true));
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)String.valueOf(object).length());
                    return;
                }
            }
        }
    }

    private final int zzap(String string) {
        if ("_ldl".equals(string)) {
            this.zzx.zzc();
            return 2048;
        }
        if (!"_id".equals(string)) {
            if (this.zzx.zzc().zzn(null, zzdw.zzaf) && "_lgclid".equals(string)) {
                this.zzx.zzc();
                return 100;
            }
            this.zzx.zzc();
            return 36;
        }
        this.zzx.zzc();
        return 256;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzJ(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzt("user property referrer", string, this.zzap(string), object) : this.zzt("user property", string, this.zzap(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzK(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zzao(this.zzap(string), object, true, false);
        }
        return this.zzao(this.zzap(string), object, false, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzL(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        this.zzx.zzat().zzh().zzc("Not putting event parameter. Invalid value type. name, type", this.zzx.zzm().zzd((String)var2_5), var1_3);
    }

    final void zzM(zzkj zzkj2, String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzkk.zzam(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzkw.zzb();
        if (this.zzx.zzc().zzn(null, zzdw.zzaA)) {
            zzkj2.zza(string, bundle);
            return;
        }
        this.zzx.zzas();
        this.zzx.zzk().zzs("auto", "_err", bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzN() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzO(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        for (int i = n + -1; i >= 0 && i >= byArray.length + -8; n2 += 8, --i) {
            long l2 = l + (((long)byArray[i] & 0xFFL) << n2);
            l = l2;
        }
        return l;
    }

    static boolean zzP(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzkk.zzaq(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzkk.zzaq(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzaq(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    @WorkerThread
    final boolean zzQ(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzx.zzaw()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzx.zzat().zzj().zzb("Permission not granted", string);
        return false;
    }

    static boolean zzR(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzS(String string, String string2) {
        if (string != null || string2 != null) {
            if (string == null) {
                return false;
            }
            return string.equals(string2);
        }
        return true;
    }

    final boolean zzT(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object = this.zzx;
        object = ((zzfl)object).zzc();
        object = ((zzae)object).zzu();
        this.zzx.zzas();
        return ((String)object).equals(string);
    }

    final Bundle zzU(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzE(string, bundle.get(string));
                if (object == null) {
                    this.zzx.zzat().zzh().zzb("Param value can't be null", this.zzx.zzm().zzd(string));
                    continue;
                }
                this.zzL(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final zzas zzV(String object, String string, Bundle object2, String string2, long l, boolean bl, boolean bl2) {
        void var5_11;
        void var7_12;
        void var4_10;
        void var3_7;
        void var3_5;
        Object object3;
        void var2_4;
        if (TextUtils.isEmpty((CharSequence)var2_4)) {
            return null;
        }
        if (((zzkk)object3).zzn((String)var2_4) != 0) {
            ((zzge)object3).zzx.zzat().zzb().zzb("Invalid conditional property event name", ((zzge)object3).zzx.zzm().zze((String)var2_4));
            object3 = new IllegalArgumentException();
            throw object3;
        }
        if (var3_5 != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = new Bundle((Bundle)var3_5);
        } else {
            Bundle bundle = new Bundle();
        }
        var3_7.putString("_o", (String)var4_10);
        Bundle bundle = ((zzkk)object3).zzF((String)object, (String)var2_4, (Bundle)var3_7, CollectionUtils.listOf((Object)"_o"), false);
        object3 = var7_12 != false ? ((zzkk)object3).zzU(bundle) : bundle;
        Preconditions.checkNotNull((Object)object3);
        zzaq zzaq2 = new zzaq((Bundle)object3);
        return new zzas((String)var2_4, zzaq2, (String)var4_10, (long)var5_11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzW(Context signature, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        signature = Wrappers.packageManager((Context)signature).getPackageInfo((String)signatureArray, 64);
        if (signature == null) return true;
        signatureArray = signature.signatures;
        if (signatureArray == null) return true;
        int n = signature.signatures.length;
        if (n <= 0) return true;
        try {
            signature = signature.signatures;
            signature = signature[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature.toByteArray());
            return ((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream)).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzx.zzat().zzb().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzx.zzat().zzb().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    final byte[] zzX(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzkk zzkk2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzkk2, 0);
            object = zzkk2.marshall();
        }
        finally {
            zzkk2.recycle();
        }
        return object;
    }

    private static boolean zzar(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzkk.zzS(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean zzY(String string) {
        return !zzc[0].equals(string);
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzZ() {
        if (this.zzg == null) {
            this.zzg = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzx.zzaw()) / 1000;
        }
        return this.zzg;
    }

    public final int zzaa(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzx.zzaw(), 12451000);
    }

    public final long zzab(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final void zzac(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            this.zzx.zzat().zze().zzb("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zzad(zzs zzs2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzae(zzs zzs2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzaf(zzs zzs2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzag(zzs zzs2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzah(zzs zzs2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzai(zzs zzs2, Bundle bundle) {
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzaj(zzs zzs2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzs2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzat().zze().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzak(List<zzaa> object) {
        if (object == null) {
            object = new ArrayList(0);
            return object;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzaa)((Object)object.next());
            Bundle bundle = new Bundle();
            bundle.putString("app_id", abstractSafeParcelable.zza);
            bundle.putString("origin", abstractSafeParcelable.zzb);
            bundle.putLong("creation_timestamp", abstractSafeParcelable.zzd);
            bundle.putString("name", abstractSafeParcelable.zzc.zzb);
            zzgh.zza((Bundle)bundle, (Object)abstractSafeParcelable.zzc.zza());
            bundle.putBoolean("active", abstractSafeParcelable.zze);
            Object object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzas)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzg.zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzaq)object2).zzf());
                }
            }
            bundle.putLong("trigger_timeout", abstractSafeParcelable.zzh);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzas)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzi.zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzaq)object2).zzf());
                }
            }
            bundle.putLong("triggered_timestamp", abstractSafeParcelable.zzc.zzc);
            bundle.putLong("time_to_live", abstractSafeParcelable.zzj);
            object2 = abstractSafeParcelable.zzk;
            if (object2 != null) {
                bundle.putString("expired_event_name", ((zzas)((Object)object2)).zza);
                abstractSafeParcelable = abstractSafeParcelable.zzk.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzf());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzal(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            Object object3 = new Object[4];
            Object[] objectArray = new Object[]{39000L, this.zzZ()};
            object3[0] = String.format("v%s.%s", objectArray);
            object3[1] = object;
            object3[2] = string;
            object3[3] = l2;
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", (Object[])object3);
            object3 = this.zzx.zzc();
            boolean bl = string.equals(((zzae)object3).zzv());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzx.zzat().zzb().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    static {
        String[] stringArray = new String[]{"firebase_", "google_", "ga_"};
        zzb = stringArray;
        stringArray = new String[]{"_err"};
        zzc = stringArray;
    }

    static final boolean zzam(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzan(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

