/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzjb;

@VisibleForTesting
public final class zzja
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzee zzc;
    final /* synthetic */ zzjb zza;

    protected zzja(zzjb zzjb2) {
        this.zza = zzjb2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        ((zzge)this.zza).zzg();
        Context context = this.zza.zzx.zzaw();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzge)object).zzx.zzat();
                ((zzei)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzge zzge2 = this.zza;
            zzge2 = zzge2.zzx.zzat();
            ((zzei)zzge2).zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjb.zzI(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzge)object).zzx.zzat();
            ((zzei)object).zzb().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzdz;
                object = bl ? (zzdz)object : new zzdx((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzge)object2).zzx.zzat();
                ((zzei)object2).zzk().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzge)object2).zzx.zzat();
                ((zzei)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzge)object2).zzx.zzat();
            ((zzei)object2).zzb().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzge)object2).zzx.zzau();
            zziv zziv2 = new zziv(this, (zzdz)object);
            ((zzfi)object2).zzh(zziv2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzge)object2).zzx.zzaw();
            object.unbindService((Context)object2, (ServiceConnection)zzjb.zzI(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzx.zzat().zzj().zza("Service disconnected");
        zzgg zzgg2 = this.zza;
        zzgg2 = ((zzge)zzgg2).zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zziw zziw2 = new zziw(this, componentName);
        ((zzfi)zzgg2).zzh(zziw2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzge)this.zza).zzg();
        Object object = this.zza.zzx.zzaw();
        synchronized (this) {
            zzee zzee2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = object.zzx.zzat();
                object.zzk().zza("Connection attempt already in progress");
                return;
            }
            zzee zzee3 = this.zzc;
            if (zzee3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = object.zzx.zzat();
                object.zzk().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzee2 = new zzee((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = object.zzx.zzat();
            object.zzk().zza("Connecting to remote service");
            this.zzb = true;
            object = this.zzc;
            Preconditions.checkNotNull((Object)object);
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzdz)this.zzc.getService();
            zzge zzge2 = this.zza;
            zzge2 = zzge2.zzx.zzau();
            zzix zzix2 = new zzix(this, (zzdz)object);
            ((zzfi)zzge2).zzh(zzix2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzx.zzat().zzj().zza("Service connection suspended");
        zzgg zzgg2 = this.zza;
        zzgg2 = ((zzge)zzgg2).zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zziy zziy2 = new zziy(this);
        ((zzfi)zzgg2).zzh(zziy2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzx.zzf();
        if (object2 != null) {
            ((zzei)object2).zze().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzge)object).zzx;
            object = ((zzfl)object).zzau();
            object2 = new zziz(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzfi)object).zzh((Runnable)object2);
    }

    static /* synthetic */ boolean zzd(zzja zzja2, boolean bl) {
        zzja2.zzb = false;
        return false;
    }
}

