/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzkk;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzib
extends zzf {
    private volatile zzhu zzb;
    private zzhu zzc;
    @VisibleForTesting
    protected zzhu zza;
    private final Map<Activity, zzhu> zzd;
    @GuardedBy(value="activityLock")
    private Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile zzhu zzg;
    private zzhu zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj;
    @GuardedBy(value="this")
    private zzhu zzk;
    @GuardedBy(value="this")
    private String zzl;

    public zzib(zzfl concurrentHashMap) {
        super((zzfl)((Object)concurrentHashMap));
        concurrentHashMap = new ConcurrentHashMap<Activity, zzhu>();
        this.zzj = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap<Activity, zzhu>();
        this.zzd = concurrentHashMap;
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final zzhu zzh(boolean bl) {
        this.zzb();
        ((zzge)this).zzg();
        if (!this.zzx.zzc().zzn(null, zzdw.zzat) || !bl) {
            return this.zza;
        }
        zzhu zzhu2 = this.zza;
        if (zzhu2 != null) {
            return zzhu2;
        }
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final String zzi(Class<?> object, String string) {
        if ((object = ((Class)object).getCanonicalName()) == null) {
            return "Activity";
        }
        int n = ((Object)(object = ((String)object).split("\\."))).length;
        object = n > 0 ? object[n + -1] : "";
        n = ((String)object).length();
        this.zzx.zzc();
        if (n > 100) {
            this.zzx.zzc();
            return ((String)object).substring(0, 100);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzj(Bundle bundle, long l) {
        Object object;
        Object object2;
        zzge zzge2;
        Object object3;
        block18: {
            block19: {
                block16: {
                    block17: {
                        if (!zzge2.zzx.zzc().zzn(null, zzdw.zzat)) {
                            zzge2.zzx.zzat().zzh().zza("Manual screen reporting is disabled.");
                            return;
                        }
                        object3 = ((zzib)zzge2).zzj;
                        // MONITORENTER : object3
                        int n = ((zzib)zzge2).zzi;
                        if (n == 0) {
                            zzge2 = zzge2.zzx.zzat();
                            ((zzei)zzge2).zzh().zza("Cannot log screen view event when the app is in the background.");
                            // MONITOREXIT : object3
                            return;
                        }
                        object2 = bundle.getString("screen_name");
                        if (object2 == null) break block16;
                        n = ((String)object2).length();
                        if (n <= 0) break block17;
                        n = ((String)object2).length();
                        zzge2.zzx.zzc();
                        if (n <= 100) break block16;
                    }
                    zzge2 = zzge2.zzx.zzat();
                    ((zzei)zzge2).zzh().zzb("Invalid screen name length for screen view. Length", ((String)object2).length());
                    // MONITOREXIT : object3
                    return;
                }
                if ((object = bundle.getString("screen_class")) == null) break block18;
                int n = ((String)object).length();
                if (n <= 0) break block19;
                n = ((String)object).length();
                zzge2.zzx.zzc();
                if (n <= 100) break block18;
            }
            zzge2 = zzge2.zzx.zzat();
            ((zzei)zzge2).zzh().zzb("Invalid screen class length for screen view. Length", ((String)object).length());
            // MONITOREXIT : object3
            return;
        }
        if (object == null) {
            object = ((zzib)zzge2).zze;
            object = object != null ? ((zzib)zzge2).zzi(object.getClass(), "Activity") : "Activity";
        }
        zzhu zzhu2 = ((zzib)zzge2).zzb;
        boolean bl = ((zzib)zzge2).zzf;
        if (bl && zzhu2 != null) {
            ((zzib)zzge2).zzf = false;
            String string = zzhu2.zzb;
            bl = zzkk.zzS(string, (String)object);
            boolean bl2 = zzkk.zzS(zzhu2.zza, (String)object2);
            if (bl && bl2) {
                zzge2 = zzge2.zzx.zzat();
                ((zzei)zzge2).zzh().zza("Ignoring call to log screen view event with duplicate parameters.");
                // MONITOREXIT : object3
                return;
            }
        }
        // MONITOREXIT : object3
        zzeg zzeg2 = zzge2.zzx.zzat().zzk();
        object3 = object2 == null ? "null" : object2;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        Object object4 = object == null ? "null" : object;
        zzeg2.zzc("Logging screen view with name, class", object3, object4);
        object3 = ((zzib)zzge2).zzb == null ? ((zzib)zzge2).zzc : ((zzib)zzge2).zzb;
        ((zzib)zzge2).zzb = object4 = new zzhu((String)object2, (String)object, zzge2.zzx.zzl().zzd(), true, l);
        ((zzib)zzge2).zzc = object3;
        ((zzib)zzge2).zzg = object4;
        object = zzge2.zzx;
        object = ((zzfl)object).zzax();
        l = object.elapsedRealtime();
        object = zzge2.zzx;
        object = ((zzfl)object).zzau();
        object2 = new zzhv((zzib)zzge2, bundle, (zzhu)object4, (zzhu)object3, l);
        ((zzfi)object).zzh((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @MainThread
    public final void zzk(@NonNull Activity activity, @Size(min=1L, max=36L) String string, @Size(min=1L, max=36L) String string2) {
        block9: {
            block11: {
                block10: {
                    int n;
                    block8: {
                        if (!this.zzx.zzc().zzt()) {
                            this.zzx.zzat().zzh().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
                            return;
                        }
                        zzhu zzhu2 = this.zzb;
                        if (zzhu2 == null) {
                            this.zzx.zzat().zzh().zza("setCurrentScreen cannot be called while no activity active");
                            return;
                        }
                        if (this.zzd.get(activity) == null) {
                            this.zzx.zzat().zzh().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
                            return;
                        }
                        if (string2 == null) {
                            string2 = this.zzi(activity.getClass(), "Activity");
                        }
                        String string3 = zzhu2.zzb;
                        boolean bl = zzkk.zzS(string3, string2);
                        n = zzkk.zzS(zzhu2.zza, string);
                        if (bl && n != 0) {
                            this.zzx.zzat().zzh().zza("setCurrentScreen cannot be called with the same class and name");
                            return;
                        }
                        if (string == null) break block8;
                        if (string.length() <= 0) break block9;
                        n = string.length();
                        this.zzx.zzc();
                        if (n > 100) break block9;
                    }
                    if (string2 == null) break block10;
                    if (string2.length() <= 0) break block11;
                    n = string2.length();
                    this.zzx.zzc();
                    if (n > 100) break block11;
                }
                zzeg zzeg2 = this.zzx.zzat().zzk();
                Object object = string == null ? "null" : string;
                zzeg2.zzc("Setting current screen to name, class", object, string2);
                object = new zzhu(string, string2, this.zzx.zzl().zzd());
                this.zzd.put(activity, (zzhu)object);
                this.zzA(activity, (zzhu)object, true);
                return;
            }
            this.zzx.zzat().zzh().zzb("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzx.zzat().zzh().zzb("Invalid screen name length in setCurrentScreen. Length", string.length());
    }

    public final zzhu zzl() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @MainThread
    private final void zzA(Activity object, zzhu object2, boolean bl) {
        Object object3;
        zzhu zzhu2 = this.zzb == null ? this.zzc : this.zzb;
        if (((zzhu)object2).zzb == null) {
            object = object != null ? this.zzi(object.getClass(), "Activity") : null;
            object = object3 = new zzhu(((zzhu)object2).zza, (String)object, ((zzhu)object2).zzc, ((zzhu)object2).zze, ((zzhu)object2).zzf);
        } else {
            object = object2;
        }
        this.zzc = this.zzb;
        this.zzb = object;
        object2 = this.zzx;
        object2 = ((zzfl)object2).zzax();
        long l = object2.elapsedRealtime();
        object2 = this.zzx;
        object2 = ((zzfl)object2).zzau();
        object3 = new zzhw(this, (zzhu)object, zzhu2, l, bl);
        ((zzfi)object2).zzh((Runnable)object3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzB(zzhu zzhu2, zzhu object, long l, boolean bl, Bundle bundle) {
        ((zzge)this).zzg();
        bl = bl ? this.zza != null : false;
        if (bl) {
            this.zzC(this.zza, true, l);
        }
        if (object == null || ((zzhu)object).zzc != zzhu2.zzc || !zzkk.zzS(((zzhu)object).zzb, zzhu2.zzb) || !zzkk.zzS(((zzhu)object).zza, zzhu2.zza)) {
            Bundle bundle2;
            Bundle bundle3 = new Bundle();
            bundle = this.zzx.zzc().zzn(null, zzdw.zzat) ? (bundle != null ? (bundle2 = new Bundle(bundle)) : new Bundle()) : bundle3;
            zzib.zzm(zzhu2, bundle, true);
            if (object != null) {
                String string;
                String string2 = ((zzhu)object).zza;
                if (string2 != null) {
                    bundle.putString("_pn", string2);
                }
                if ((string = ((zzhu)object).zzb) != null) {
                    bundle.putString("_pc", string);
                }
                bundle.putLong("_pi", ((zzhu)object).zzc);
            }
            if (bl) {
                object = this.zzx.zzh().zzb;
                long l2 = l - ((zzjo)object).zzb;
                ((zzjo)object).zzb = l;
                if (l2 > 0L) {
                    this.zzx.zzl().zzac(bundle, l2);
                }
            }
            if (this.zzx.zzc().zzn(null, zzdw.zzat)) {
                if (!this.zzx.zzc().zzt()) {
                    bundle.putLong("_mst", 1L);
                }
                object = !zzhu2.zze ? "auto" : "app";
            } else {
                object = "auto";
            }
            if (this.zzx.zzc().zzn(null, zzdw.zzat)) {
                long l3;
                long l4 = this.zzx.zzax().currentTimeMillis();
                long l5 = zzhu2.zze ? ((l3 = zzhu2.zzf) != 0L ? l3 : l4) : l4;
                this.zzx.zzk().zzt((String)object, "_vs", l5, bundle);
            } else {
                zzhn zzhn2 = this.zzx.zzk();
                zzfl cfr_ignored_0 = zzhn2.zzx;
                ((zzge)zzhn2).zzg();
                zzhn2.zzt((String)object, "_vs", zzhn2.zzx.zzax().currentTimeMillis(), bundle);
            }
        }
        this.zza = zzhu2;
        if (this.zzx.zzc().zzn(null, zzdw.zzat) && zzhu2.zze) {
            this.zzh = zzhu2;
        }
        this.zzx.zzy().zzz(zzhu2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzC(zzhu zzhu2, boolean bl, long l) {
        this.zzx.zzB().zzc(this.zzx.zzax().elapsedRealtime());
        boolean bl2 = zzhu2 != null ? zzhu2.zzd : false;
        if (this.zzx.zzh().zzb.zzd(bl2, bl, l) && zzhu2 != null) {
            zzhu2.zzd = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzm(zzhu zzhu2, Bundle bundle, boolean bl) {
        if (zzhu2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzhu2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzhu2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzhu2.zzc);
                return;
            }
            bl = false;
        }
        if (zzhu2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzn(String string, zzhu zzhu2) {
        ((zzge)this).zzg();
        synchronized (this) {
            boolean bl;
            String string2 = this.zzl;
            if (string2 != null && !(bl = string2.equals(string))) {
                if (zzhu2 == null) return;
            }
            this.zzl = string;
            this.zzk = zzhu2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @MainThread
    private final zzhu zzD(@NonNull Activity object) {
        void var1_3;
        Preconditions.checkNotNull((Object)object);
        Object object2 = this.zzd.get(object);
        if (object2 == null) {
            object2 = object.getClass();
            object2 = this.zzi((Class<?>)object2, "Activity");
            zzhu zzhu2 = new zzhu(null, (String)object2, this.zzx.zzl().zzd());
            this.zzd.put((Activity)object, zzhu2);
            zzhu zzhu3 = zzhu2;
        } else {
            zzhu zzhu4 = object2;
        }
        if (!this.zzx.zzc().zzn(null, zzdw.zzat)) {
            return var1_3;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return var1_3;
    }

    @MainThread
    public final void zzo(Activity activity, Bundle bundle) {
        if (!this.zzx.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        if ((bundle = bundle.getBundle("com.google.app_measurement.screen_service")) == null) {
            return;
        }
        zzhu zzhu2 = new zzhu(bundle.getString("name"), bundle.getString("referrer_name"), bundle.getLong("id"));
        this.zzd.put(activity, zzhu2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzq(Activity object) {
        Object object2;
        block12: {
            if (zze2.zzx.zzc().zzn(null, zzdw.zzat)) {
                object2 = zze2.zzj;
                synchronized (object2) {
                    zze2.zzi = true;
                    Object object3 = zze2.zze;
                    if (object != object3) {
                        zzgg zzgg2;
                        Object object4;
                        object3 = zze2.zzj;
                        synchronized (object3) {
                            zze2.zze = object;
                            zze2.zzf = false;
                            // MONITOREXIT @DISABLED, blocks:[2, 6, 7, 10, 11] lbl12 : MonitorExitStatement: MONITOREXIT : var3_4
                            object3 = zze2.zzx.zzc();
                            object4 = zzdw.zzas;
                            boolean bl = ((zzae)object3).zzn(null, (zzdv<Boolean>)object4);
                            if (!bl || !(bl = zze2.zzx.zzc().zzt())) break block12;
                            zze2.zzg = null;
                            zzgg2 = zze2.zzx;
                            zzgg2 = ((zzfl)zzgg2).zzau();
                            object4 = new zzia((zzib)zze2);
                        }
                        ((zzfi)zzgg2).zzh((Runnable)object4);
                    }
                }
            }
        }
        if (zze2.zzx.zzc().zzn(null, zzdw.zzas) && !zze2.zzx.zzc().zzt()) {
            zze2.zzb = zze2.zzg;
            object = zze2.zzx;
            object = ((zzfl)object).zzau();
            object2 = new zzhx((zzib)zze2);
            ((zzfi)object).zzh((Runnable)object2);
            return;
        }
        zze2.zzA((Activity)object, zze2.zzD((Activity)object), false);
        zze zze2 = zze2.zzx.zzB();
        object = zze2.zzx;
        object = ((zzfl)object).zzax();
        long l = object.elapsedRealtime();
        object = zze2.zzx;
        object = ((zzfl)object).zzau();
        object2 = new zzc((zzd)zze2, l);
        ((zzfi)object).zzh((Runnable)object2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzr(Activity object) {
        Object object2;
        if (this.zzx.zzc().zzn(null, zzdw.zzat)) {
            object2 = this.zzj;
            synchronized (object2) {
                this.zzi = false;
                this.zzf = true;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        long l = this.zzx.zzax().elapsedRealtime();
        if (this.zzx.zzc().zzn(null, zzdw.zzas) && !this.zzx.zzc().zzt()) {
            this.zzb = null;
            object = this.zzx;
            object = ((zzfl)object).zzau();
            object2 = new zzhy(this, l);
            ((zzfi)object).zzh((Runnable)object2);
            return;
        }
        object = this.zzD((Activity)object);
        this.zzc = this.zzb;
        this.zzb = null;
        object2 = this.zzx;
        object2 = ((zzfl)object2).zzau();
        zzhz zzhz2 = new zzhz(this, (zzhu)object, l);
        ((zzfi)object2).zzh(zzhz2);
    }

    @MainThread
    public final void zzs(Activity activity, Bundle bundle) {
        if (!((zzge)((Object)zzhu2)).zzx.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzhu zzhu2 = ((zzib)((Object)zzhu2)).zzd.get(activity);
        if (zzhu2 == null) {
            return;
        }
        activity = new Bundle();
        activity.putLong("id", zzhu2.zzc);
        activity.putString("name", zzhu2.zza);
        activity.putString("referrer_name", zzhu2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", (Bundle)activity);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void zzt(Activity activity) {
        Object object = this.zzj;
        // MONITORENTER : object
        Activity activity2 = this.zze;
        if (activity == activity2) {
            this.zze = null;
            // MONITOREXIT : object
        }
        if (!this.zzx.zzc().zzt()) {
            return;
        }
        this.zzd.remove(activity);
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }

    static /* synthetic */ void zzu(zzib zzib2, Bundle bundle, zzhu zzhu2, zzhu zzhu3, long l) {
        bundle.remove("screen_name");
        bundle.remove("screen_class");
        zzib2.zzB(zzhu2, zzhu3, l, true, zzib2.zzx.zzl().zzF(null, "screen_view", bundle, null, true));
    }

    static /* synthetic */ void zzv(zzib zzib2, zzhu zzhu2, zzhu zzhu3, long l, boolean bl, Bundle bundle) {
        zzib2.zzB(zzhu2, zzhu3, l, bl, null);
    }

    static /* synthetic */ zzhu zzx(zzib zzib2) {
        return zzib2.zzh;
    }

    static /* synthetic */ void zzy(zzib zzib2, zzhu zzhu2, boolean bl, long l) {
        zzib2.zzC(zzhu2, false, l);
    }

    static /* synthetic */ zzhu zzz(zzib zzib2, zzhu zzhu2) {
        zzib2.zzh = null;
        return null;
    }
}

