/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzjx;
import java.util.Map;

public final class zzhx
extends zzg {
    @VisibleForTesting
    protected zzhu zza;
    private volatile zzhu zzb;
    private zzhu zzc;
    private final Map<Activity, zzhu> zzd = new ArrayMap();
    private zzhu zze;
    private String zzf;

    public zzhx(zzfn zzfn2) {
        super(zzfn2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzhu zzab() {
        this.zzw();
        ((zzgj)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzgj)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgj)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzhx.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzjx.zzd(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgj)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgj)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgj)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgj)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzhu zzhu2 = new zzhu(string, string2, ((zzgj)this).zzp().zzg());
        this.zzd.put(activity, zzhu2);
        this.zza(activity, zzhu2, true);
    }

    public final zzhu zzac() {
        ((zzgj)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzhu zzhu2, boolean bl) {
        zzhu zzhu3;
        zzhu zzhu4 = zzhu3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzhu2.zzb == null) {
            zzhu2 = new zzhu(zzhu2.zza, zzhx.zza(activity.getClass().getCanonicalName()), zzhu2.zzc);
        }
        zzhu zzhu5 = zzhu2;
        this.zzc = this.zzb;
        this.zzb = zzhu5;
        ((zzgj)this).zzq().zza(new zzhw(this, bl, zzhu3, zzhu5));
    }

    @WorkerThread
    private final void zza(@NonNull zzhu zzhu2, boolean bl) {
        ((zzd)this).zze().zza(((zzgj)this).zzm().elapsedRealtime());
        if (((zzd)this).zzk().zza(zzhu2.zzd, bl)) {
            zzhu2.zzd = false;
        }
    }

    public static void zza(zzhu zzhu2, Bundle bundle, boolean bl) {
        if (bundle != null && zzhu2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzhu2.zza != null) {
                bundle.putString("_sn", zzhu2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzhu2.zzb);
            bundle.putLong("_si", zzhu2.zzc);
            return;
        }
        if (bundle != null && zzhu2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzhu zzhu2) {
        ((zzgj)this).zzd();
        zzhx zzhx2 = this;
        synchronized (zzhx2) {
            if (this.zzf == null || this.zzf.equals(string) || zzhu2 != null) {
                this.zzf = string;
                this.zze = zzhu2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzhu zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzhu zzhu2 = this.zzd.get(activity);
        if (zzhu2 == null) {
            String string = zzhx.zza(activity.getClass().getCanonicalName());
            zzhu2 = new zzhu(null, string, ((zzgj)this).zzp().zzg());
            this.zzd.put(activity, zzhu2);
        }
        return zzhu2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzhu zzhu2 = new zzhu(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzhu2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzhu zzhu2 = this.zzd(activity);
        this.zza(activity, zzhu2, false);
        zza zza2 = ((zzd)this).zze();
        long l = ((zzgj)zza2).zzm().elapsedRealtime();
        ((zzgj)zza2).zzq().zza(new zze(zza2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzhu zzhu2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgj)this).zzq().zza(new zzhz(this, zzhu2));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzhu zzhu2 = this.zzd.get(activity);
        if (zzhu2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzhu2.zzc);
        bundle2.putString("name", zzhu2.zza);
        bundle2.putString("referrer_name", zzhu2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzhx zzhx2, zzhu zzhu2, boolean bl) {
        zzhx2.zza(zzhu2, bl);
    }
}

