/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfn
implements zzgl {
    private static volatile zzfn zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzr zzg;
    private final zzs zzh;
    private final zzes zzi;
    private final zzej zzj;
    private final zzfg zzk;
    private final zzjd zzl;
    private final zzjx zzm;
    private final zzeh zzn;
    private final Clock zzo;
    private final zzhx zzp;
    private final zzgt zzq;
    private final zza zzr;
    private final zzho zzs;
    private zzef zzt;
    private zzhy zzu;
    private zzac zzv;
    private zzec zzw;
    private zzey zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzfn(zzgq zzgq2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgq2);
        Object object2 = zzgq2.zza;
        this.zzg = new zzr((Context)object2);
        zzak.zza(this.zzg);
        this.zzb = zzgq2.zza;
        this.zzc = zzgq2.zzb;
        this.zzd = zzgq2.zzc;
        this.zze = zzgq2.zzd;
        this.zzf = zzgq2.zzh;
        this.zzab = zzgq2.zze;
        zzx zzx2 = zzgq2.zzg;
        if (zzx2 != null && zzx2.zzg != null) {
            object = zzx2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzx2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzs((zzfn)object2);
        object2 = this;
        object = new zzes((zzfn)object2);
        ((zzgi)object).zzab();
        this.zzi = object;
        object2 = this;
        zzej zzej2 = new zzej((zzfn)object2);
        zzej2.zzab();
        this.zzj = zzej2;
        object2 = this;
        zzjx zzjx2 = new zzjx((zzfn)object2);
        zzjx2.zzab();
        this.zzm = zzjx2;
        object2 = this;
        zzeh zzeh2 = new zzeh((zzfn)object2);
        zzeh2.zzab();
        this.zzn = zzeh2;
        object2 = this;
        this.zzr = new zza((zzfn)object2);
        object2 = this;
        zzhx zzhx2 = new zzhx((zzfn)object2);
        zzhx2.zzx();
        this.zzp = zzhx2;
        object2 = this;
        zzgt zzgt2 = new zzgt((zzfn)object2);
        zzgt2.zzx();
        this.zzq = zzgt2;
        object2 = this;
        zzjd zzjd2 = new zzjd((zzfn)object2);
        zzjd2.zzx();
        this.zzl = zzjd2;
        object2 = this;
        zzho zzho2 = new zzho((zzfn)object2);
        zzho2.zzab();
        this.zzs = zzho2;
        object2 = this;
        zzfg zzfg2 = new zzfg((zzfn)object2);
        zzfg2.zzab();
        this.zzk = zzfg2;
        boolean bl = zzgq2.zzg != null && zzgq2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzr zzr2 = ((zzfn)object2).zzg;
        if (((zzfn)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzgt zzgt3 = ((zzfn)object2).zzh();
            if (((zzgj)zzgt3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgj)zzgt3).zzn().getApplicationContext();
                if (zzgt3.zza == null) {
                    zzgt3.zza = new zzhm(zzgt3, null);
                }
                if (bl3) {
                    zzhm zzhm2 = zzgt3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm2);
                    zzhm2 = zzgt3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm2);
                    ((zzgj)zzgt3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfn)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzfp(this, zzgq2));
    }

    @WorkerThread
    private final void zza(zzgq zzgq2) {
        ((zzgj)this.zzq()).zzd();
        com.google.android.gms.measurement.internal.zzs.zze();
        Object object = this;
        zzac zzac2 = new zzac((zzfn)object);
        zzac2.zzab();
        this.zzv = zzac2;
        zzfn zzfn2 = this;
        object = zzgq2;
        zzec zzec2 = new zzec(zzfn2, ((zzgq)object).zzf);
        zzec2.zzx();
        this.zzw = zzec2;
        object = this;
        zzef zzef2 = new zzef((zzfn)object);
        zzef2.zzx();
        this.zzt = zzef2;
        object = this;
        zzhy zzhy2 = new zzhy((zzfn)object);
        zzhy2.zzx();
        this.zzu = zzhy2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzey((zzfn)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement is starting up, version", this.zzh.zzf());
        zzr zzr2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzr2 = this.zzg;
        String string = zzec2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzel zzel2;
            if (this.zzi().zzf(string)) {
                zzel2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzel2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzel2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzgj)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzr zzr2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzz()) {
                    if (!zzfd.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzjx.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzr zzr3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzjx.zza(this.zzy().zzac(), this.zzc().zzg(), this.zzy().zzad(), this.zzc().zzh())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzj();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzr3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzh()) {
                    this.zzc().zzd(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzak.zzbq));
        this.zzc().zzp.zza(this.zzh.zza(zzak.zzbr));
    }

    @Override
    public final zzr zzu() {
        return this.zzg;
    }

    public final zzs zzb() {
        return this.zzh;
    }

    public final zzes zzc() {
        zzfn.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzej zzr() {
        zzfn.zzb(this.zzj);
        return this.zzj;
    }

    public final zzej zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzfg zzq() {
        zzfn.zzb(this.zzk);
        return this.zzk;
    }

    public final zzjd zze() {
        zzfn.zzb(this.zzl);
        return this.zzl;
    }

    public final zzey zzf() {
        return this.zzx;
    }

    final zzfg zzg() {
        return this.zzk;
    }

    public final zzgt zzh() {
        zzfn.zzb(this.zzq);
        return this.zzq;
    }

    public final zzjx zzi() {
        zzfn.zza(this.zzm);
        return this.zzm;
    }

    public final zzeh zzj() {
        zzfn.zza(this.zzn);
        return this.zzn;
    }

    public final zzef zzk() {
        zzfn.zzb(this.zzt);
        return this.zzt;
    }

    private final zzho zzai() {
        zzfn.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zzhx zzv() {
        zzfn.zzb(this.zzp);
        return this.zzp;
    }

    public final zzhy zzw() {
        zzfn.zzb(this.zzu);
        return this.zzu;
    }

    public final zzac zzx() {
        zzfn.zzb(this.zzv);
        return this.zzv;
    }

    public final zzec zzy() {
        zzfn.zzb(this.zzw);
        return this.zzw;
    }

    public final zza zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzfn zza(Context context, String string, String string2, Bundle bundle) {
        return zzfn.zza(context, new zzx(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfn zza(Context context, zzx zzx2) {
        if (zzx2 != null && (zzx2.zze == null || zzx2.zzf == null)) {
            zzx2 = new zzx(zzx2.zza, zzx2.zzb, zzx2.zzc, zzx2.zzd, null, null, zzx2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzfn> clazz = zzfn.class;
            synchronized (zzfn.class) {
                if (zza == null) {
                    zzgq zzgq2 = new zzgq(context, zzx2);
                    zza = new zzfn(zzgq2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzx2 != null && zzx2.zzg != null && zzx2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzx2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzaj() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzgi zzgi2) {
        if (zzgi2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgi2.zzz()) {
            String string = String.valueOf(zzgi2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzv()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgj zzgj2) {
        if (zzgj2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        boolean bl;
        ((zzgj)this.zzq()).zzd();
        this.zzaj();
        if (this.zzh.zza(zzak.zzbi)) {
            if (this.zzh.zzh()) {
                return false;
            }
            if (this.zzad != null && this.zzad.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzc().zzk();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzh.zzi();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzac != null) {
                return this.zzac;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzh.zza(zzak.zzbd) && this.zzab != null) {
                return this.zzab;
            }
            return true;
        }
        if (this.zzh.zzh()) {
            return false;
        }
        Boolean bl4 = this.zzh.zzi();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzab != null && ((Boolean)zzak.zzbd.zza(null)).booleanValue()) {
                bl = this.zzab;
            }
        }
        return this.zzc().zzc(bl);
    }

    final long zzac() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzad() {
        zzr zzr2 = this.zzg;
    }

    final void zzae() {
        zzr zzr2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgi zzgi2) {
        ++this.zzae;
    }

    final void zza(zzg zzg2) {
        ++this.zzae;
    }

    final void zzaf() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        this.zzaj();
        ((zzgj)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzr zzr2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzz() || zzfd.zza(this.zzb) && zzjx.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zzc(this.zzy().zzac(), this.zzy().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgj)this.zzq()).zzd();
        zzfn.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzj().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgj)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzfm zzfm2 = new zzfm(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzho zzho2 = this.zzai();
        ((zzgj)zzho2).zzd();
        zzho2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfm2);
        ((zzgj)zzho2).zzq().zzb(new zzhq(zzho2, string2, uRL2, null, null, zzfm2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfn zzfn2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfn2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfn2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzfn2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = string3;
            zzjx zzjx2 = zzfn2.zzi();
            ((zzgj)zzjx2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgj)zzjx2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfn2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfn2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzjx2 = zzfn2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzjx2.zzg(string5)) {
                list = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgj)zzjx2).zzn().sendBroadcast((Intent)list);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfn2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfn zzfn2, zzgq zzgq2) {
        zzfn2.zza(zzgq2);
    }
}

