/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.internal.zzg;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.analytics.connector.zzb;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzc;
    @VisibleForTesting
    final AppMeasurementSdk zza;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zzb;

    AnalyticsConnectorImpl(AppMeasurementSdk object) {
        Preconditions.checkNotNull((Object)object);
        this.zza = object;
        this.zzb = object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance(@RecentlyNonNull FirebaseApp object, @RecentlyNonNull Context context, @RecentlyNonNull Subscriber subscriber) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzc != null) return zzc;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (clazz) {
            AnalyticsConnector analyticsConnector = zzc;
            if (analyticsConnector != null) return zzc;
            analyticsConnector = new Bundle(1);
            boolean bl = object.isDefaultApp();
            if (bl) {
                Class<DataCollectionDefaultChange> clazz2 = DataCollectionDefaultChange.class;
                Executor executor = com.google.firebase.analytics.connector.zza.zza;
                subscriber.subscribe(clazz2, executor, com.google.firebase.analytics.connector.zzb.zza);
                analyticsConnector.putBoolean("dataCollectionDefaultEnabled", object.isDataCollectionDefaultEnabled());
            }
            context = zzbr.zza((Context)context, null, null, null, (Bundle)analyticsConnector).zzb();
            object = new AnalyticsConnectorImpl((AppMeasurementSdk)context);
            zzc = object;
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance(@RecentlyNonNull FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @KeepForSdk
    public void logEvent(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zza(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzb(string2, bundle)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzf(string, string2, bundle)) {
            return;
        }
        com.google.firebase.analytics.connector.internal.zzc.zzm(string, string2, bundle);
        this.zza.logEvent(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Object object) {
        if (!com.google.firebase.analytics.connector.internal.zzc.zza(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzd(string, string2)) {
            return;
        }
        this.zza.setUserProperty(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zza.getUserProperties(null, null, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @RecentlyNonNull String string, @RecentlyNonNull AnalyticsConnector.AnalyticsConnectorListener object) {
        void var2_4;
        Preconditions.checkNotNull((Object)object);
        if (!com.google.firebase.analytics.connector.internal.zzc.zza(string)) {
            return null;
        }
        if (this.zzc(string)) {
            return null;
        }
        AppMeasurementSdk appMeasurementSdk = this.zza;
        if ("fiam".equals(string)) {
            zze zze2;
            zze zze3 = zze2 = new zze(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)object);
        } else if ("crash".equals(string) || "clx".equals(string)) {
            zzg zzg2;
            zzg zzg3 = zzg2 = new zzg(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)object);
        } else {
            Object var2_7 = null;
        }
        if (var2_4 == null) return null;
        this.zzb.put(string, (com.google.firebase.analytics.connector.internal.zza)var2_4);
        return new AnalyticsConnector.AnalyticsConnectorHandle(){

            public final void unregister() {
                if (!AnalyticsConnectorImpl.this.zzc(string)) {
                    return;
                }
                AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zzb.get(string).zza();
                if (analyticsConnectorListener != null) {
                    analyticsConnectorListener.onMessageTriggered(0, null);
                }
                AnalyticsConnectorImpl.this.zzb.remove(string);
            }

            @KeepForSdk
            public void registerEventNames(Set<String> set) {
                if (!AnalyticsConnectorImpl.this.zzc(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                    return;
                }
                AnalyticsConnectorImpl.this.zzb.get(string).zzb(set);
            }

            @KeepForSdk
            public void unregisterEventNames() {
                if (!AnalyticsConnectorImpl.this.zzc(string) || !string.equals("fiam")) {
                    return;
                }
                AnalyticsConnectorImpl.this.zzb.get(string).zzc();
            }
        };
    }

    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!com.google.firebase.analytics.connector.internal.zzc.zze(conditionalUserProperty)) {
            return;
        }
        this.zza.setConditionalUserProperty(com.google.firebase.analytics.connector.internal.zzc.zzg(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle) {
        if (string2 != null && !com.google.firebase.analytics.connector.internal.zzc.zzb(string2, bundle)) {
            return;
        }
        this.zza.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@RecentlyNonNull String string, @Size(min=1L, max=23L) @RecentlyNonNull String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = ((AnalyticsConnectorImpl)((Object)iterator)).zza.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            arrayList.add(com.google.firebase.analytics.connector.internal.zzc.zzh((Bundle)iterator.next()));
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String string) {
        return this.zza.getMaxUserProperties(string);
    }

    private final boolean zzc(@NonNull String string) {
        return !string.isEmpty() && this.zzb.containsKey(string) && this.zzb.get(string) != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (clazz) {
            AnalyticsConnector analyticsConnector = zzc;
            ((AnalyticsConnectorImpl)Preconditions.checkNotNull((Object)analyticsConnector)).zza.zza(bl);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

