/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor apN;
    private LatLng apO;
    private float apP;
    private float apQ;
    private LatLngBounds anI;
    private float apF;
    private float apJ;
    private boolean apK = true;
    private float apR = 0.0f;
    private float apS = 0.5f;
    private float apT = 0.5f;
    private boolean apL = false;

    GroundOverlayOptions(int n, IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.mVersionCode = n;
        this.apN = new BitmapDescriptor(zzd.zza.zzfd((IBinder)iBinder));
        this.apO = latLng;
        this.apP = f;
        this.apQ = f2;
        this.anI = latLngBounds;
        this.apF = f3;
        this.apJ = f4;
        this.apK = bl;
        this.apR = f5;
        this.apS = f6;
        this.apT = f7;
        this.apL = bl2;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    IBinder zzbsx() {
        return this.apN.zzbsc().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.apN = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.apS = f;
        this.apT = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzaa.zza((this.anI == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzaa.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzaa.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzaa.zza((this.anI == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzaa.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzaa.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzaa.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.apO = latLng;
        this.apP = f;
        this.apQ = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.apO);
        zzaa.zza((this.apO == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.anI = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.apF = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.apJ = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.apK = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzaa.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.apR = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.apL = bl;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.apN;
    }

    public LatLng getLocation() {
        return this.apO;
    }

    public float getWidth() {
        return this.apP;
    }

    public float getHeight() {
        return this.apQ;
    }

    public LatLngBounds getBounds() {
        return this.anI;
    }

    public float getBearing() {
        return this.apF;
    }

    public float getZIndex() {
        return this.apJ;
    }

    public float getTransparency() {
        return this.apR;
    }

    public float getAnchorU() {
        return this.apS;
    }

    public float getAnchorV() {
        return this.apT;
    }

    public boolean isVisible() {
        return this.apK;
    }

    public boolean isClickable() {
        return this.apL;
    }
}

