/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanorama;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate;
import com.google.android.gms.maps.internal.IStreetViewPanoramaViewDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzaf;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class StreetViewPanoramaView
extends FrameLayout {
    private final zzb app;

    public StreetViewPanoramaView(Context context) {
        super(context);
        this.app = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.app = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.app = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
        super(context);
        this.app = new zzb((ViewGroup)this, context, streetViewPanoramaOptions);
    }

    public final void onCreate(Bundle bundle) {
        this.app.onCreate(bundle);
        if (this.app.zzbdo() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.app.onResume();
    }

    public final void onPause() {
        this.app.onPause();
    }

    public final void onDestroy() {
        this.app.onDestroy();
    }

    public final void onLowMemory() {
        this.app.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.app.onSaveInstanceState(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        zzaa.zzhs((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.app.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup aoU;
        private final Context mContext;
        protected zzf<zza> aoN;
        private final StreetViewPanoramaOptions apt;
        private final List<OnStreetViewPanoramaReadyCallback> aph = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
            this.aoU = viewGroup;
            this.mContext = context;
            this.apt = streetViewPanoramaOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.aoN = zzf2;
            this.zzbsp();
        }

        public void zzbsp() {
            if (this.aoN != null && this.zzbdo() == null) {
                try {
                    IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate = zzai.zzdm(this.mContext).zza(zze.zzac((Object)this.mContext), this.apt);
                    this.aoN.zza((LifecycleDelegate)new zza(this.aoU, iStreetViewPanoramaViewDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : this.aph) {
                        ((zza)this.zzbdo()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    this.aph.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
            } else {
                this.aph.add(onStreetViewPanoramaReadyCallback);
            }
        }
    }

    static class zza
    implements StreetViewLifecycleDelegate {
        private final ViewGroup aoQ;
        private final IStreetViewPanoramaViewDelegate apq;
        private View apr;

        public zza(ViewGroup viewGroup, IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate) {
            this.apq = (IStreetViewPanoramaViewDelegate)zzaa.zzy((Object)iStreetViewPanoramaViewDelegate);
            this.aoQ = (ViewGroup)zzaa.zzy((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on StreetViewPanoramaViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.apq.onCreate(bundle);
                this.apr = (View)zze.zzae((zzd)this.apq.getView());
                this.aoQ.removeAllViews();
                this.aoQ.addView(this.apr);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on StreetViewPanoramaViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.apq.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.apq.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on StreetViewPanoramaViewDelegate");
        }

        public void onDestroy() {
            try {
                this.apq.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.apq.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.apq.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getStreetViewPanoramaAsync(final OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.apq.getStreetViewPanoramaAsync(new zzaf.zza(){

                    @Override
                    public void zza(IStreetViewPanoramaDelegate iStreetViewPanoramaDelegate) throws RemoteException {
                        onStreetViewPanoramaReadyCallback.onStreetViewPanoramaReady(new StreetViewPanorama(iStreetViewPanoramaDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

