/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzb afO = new zzb(this);

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions googleMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.afO.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.afO.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.afO.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.afO.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.afO.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.afO.onResume();
    }

    public void onPause() {
        this.afO.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.afO.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.afO.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.afO.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.afO.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzab.zzhi((String)"onEnterAmbient must be called on the main thread.");
        this.afO.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzab.zzhi((String)"onExitAmbient must be called on the main thread.");
        this.afO.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzab.zzhi((String)"getMapAsync must be called on the main thread.");
        this.afO.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment KC;
        protected zzf<zza> afS;
        private Activity mActivity;
        private final List<OnMapReadyCallback> afT = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.KC = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.afS = zzf2;
            this.zzbow();
        }

        public void zzbow() {
            if (this.mActivity != null && this.afS != null && this.zzbbt() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzai.zzdk((Context)this.mActivity).zzag(zze.zzac((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.afS.zza((LifecycleDelegate)new zza(this.KC, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.afT) {
                        ((zza)this.zzbbt()).getMapAsync(onMapReadyCallback);
                    }
                    this.afT.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzbow();
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).getMapAsync(onMapReadyCallback);
            } else {
                this.afT.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment KC;
        private final IMapFragmentDelegate afP;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.afP = (IMapFragmentDelegate)zzab.zzy((Object)iMapFragmentDelegate);
            this.KC = (Fragment)zzab.zzy((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                this.afP.onInflate(zze.zzac((Object)activity), googleMapOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2;
                if (bundle == null) {
                    bundle = new Bundle();
                }
                if ((bundle2 = this.KC.getArguments()) != null && bundle2.containsKey("MapOptions")) {
                    zzah.zza(bundle, "MapOptions", bundle2.getParcelable("MapOptions"));
                }
                this.afP.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            zzd zzd2;
            try {
                zzd2 = this.afP.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzad((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.afP.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.afP.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.afP.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.afP.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.afP.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.afP.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.afP.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.afP.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.afP.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

