/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor aiq;
    private LatLng air;
    private float ais;
    private float ait;
    private LatLngBounds agp;
    private float aif;
    private float aim;
    private boolean ain = true;
    private float aiu = 0.0f;
    private float aiv = 0.5f;
    private float aiw = 0.5f;
    private boolean aio = false;

    GroundOverlayOptions(int n, IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.mVersionCode = n;
        this.aiq = new BitmapDescriptor(zzd.zza.zzfc((IBinder)iBinder));
        this.air = latLng;
        this.ais = f;
        this.ait = f2;
        this.agp = latLngBounds;
        this.aif = f3;
        this.aim = f4;
        this.ain = bl;
        this.aiu = f5;
        this.aiv = f6;
        this.aiw = f7;
        this.aio = bl2;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzbqg() {
        return this.aiq.zzbpg().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.aiq = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.aiv = f;
        this.aiw = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzab.zza((this.agp == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzab.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzab.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzab.zza((this.agp == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzab.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzab.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzab.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.air = latLng;
        this.ais = f;
        this.ait = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf(this.air);
        zzab.zza((this.air == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.agp = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.aif = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.aim = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.ain = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzab.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.aiu = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.aio = bl;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.aiq;
    }

    public LatLng getLocation() {
        return this.air;
    }

    public float getWidth() {
        return this.ais;
    }

    public float getHeight() {
        return this.ait;
    }

    public LatLngBounds getBounds() {
        return this.agp;
    }

    public float getBearing() {
        return this.aif;
    }

    public float getZIndex() {
        return this.aim;
    }

    public float getTransparency() {
        return this.aiu;
    }

    public float getAnchorU() {
        return this.aiv;
    }

    public float getAnchorV() {
        return this.aiw;
    }

    public boolean isVisible() {
        return this.ain;
    }

    public boolean isClickable() {
        return this.aio;
    }
}

