/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.internal.IUiSettingsDelegate;
import com.google.android.gms.maps.internal.zzac;
import com.google.android.gms.maps.internal.zzb;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.internal.zzg;
import com.google.android.gms.maps.internal.zzh;
import com.google.android.gms.maps.internal.zzi;
import com.google.android.gms.maps.internal.zzj;
import com.google.android.gms.maps.internal.zzk;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzn;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.internal.zzq;
import com.google.android.gms.maps.internal.zzr;
import com.google.android.gms.maps.internal.zzs;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.internal.zzu;
import com.google.android.gms.maps.internal.zzv;
import com.google.android.gms.maps.internal.zzw;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.zzb;
import com.google.android.gms.maps.model.internal.zzc;
import com.google.android.gms.maps.model.internal.zzd;
import com.google.android.gms.maps.model.internal.zzf;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzh;

public interface IGoogleMapDelegate
extends IInterface {
    public CameraPosition getCameraPosition() throws RemoteException;

    public float getMaxZoomLevel() throws RemoteException;

    public float getMinZoomLevel() throws RemoteException;

    public void moveCamera(com.google.android.gms.dynamic.zzd var1) throws RemoteException;

    public void animateCamera(com.google.android.gms.dynamic.zzd var1) throws RemoteException;

    public void animateCameraWithCallback(com.google.android.gms.dynamic.zzd var1, zzb var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.zzd var1, int var2, zzb var3) throws RemoteException;

    public void stopAnimation() throws RemoteException;

    public IPolylineDelegate addPolyline(PolylineOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzg addPolygon(PolygonOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzf addMarker(MarkerOptions var1) throws RemoteException;

    public zzc addGroundOverlay(GroundOverlayOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzh addTileOverlay(TileOverlayOptions var1) throws RemoteException;

    public void clear() throws RemoteException;

    public int getMapType() throws RemoteException;

    public void setMapType(int var1) throws RemoteException;

    public boolean isTrafficEnabled() throws RemoteException;

    public void setTrafficEnabled(boolean var1) throws RemoteException;

    public boolean isIndoorEnabled() throws RemoteException;

    public boolean setIndoorEnabled(boolean var1) throws RemoteException;

    public boolean isMyLocationEnabled() throws RemoteException;

    public void setMyLocationEnabled(boolean var1) throws RemoteException;

    public Location getMyLocation() throws RemoteException;

    public void setLocationSource(ILocationSourceDelegate var1) throws RemoteException;

    public IUiSettingsDelegate getUiSettings() throws RemoteException;

    public IProjectionDelegate getProjection() throws RemoteException;

    public void setOnCameraChangeListener(zze var1) throws RemoteException;

    public void setOnMapClickListener(zzm var1) throws RemoteException;

    public void setOnMapLongClickListener(zzo var1) throws RemoteException;

    public void setOnMarkerClickListener(zzq var1) throws RemoteException;

    public void setOnMarkerDragListener(zzr var1) throws RemoteException;

    public void setOnInfoWindowClickListener(zzi var1) throws RemoteException;

    public void setInfoWindowAdapter(zzd var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzb addCircle(CircleOptions var1) throws RemoteException;

    public void setOnMyLocationChangeListener(zzt var1) throws RemoteException;

    public void setOnMyLocationButtonClickListener(zzs var1) throws RemoteException;

    public void snapshot(zzac var1, com.google.android.gms.dynamic.zzd var2) throws RemoteException;

    public void setPadding(int var1, int var2, int var3, int var4) throws RemoteException;

    public boolean isBuildingsEnabled() throws RemoteException;

    public void setBuildingsEnabled(boolean var1) throws RemoteException;

    public void setOnMapLoadedCallback(zzn var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzd getFocusedBuilding() throws RemoteException;

    public void setOnIndoorStateChangeListener(zzh var1) throws RemoteException;

    public void setWatermarkEnabled(boolean var1) throws RemoteException;

    public void getMapAsync(zzp var1) throws RemoteException;

    public void onCreate(Bundle var1) throws RemoteException;

    public void onResume() throws RemoteException;

    public void onPause() throws RemoteException;

    public void onDestroy() throws RemoteException;

    public void onLowMemory() throws RemoteException;

    public boolean useViewLifecycleWhenInFragment() throws RemoteException;

    public void onSaveInstanceState(Bundle var1) throws RemoteException;

    public void setContentDescription(String var1) throws RemoteException;

    public void snapshotForTest(zzac var1) throws RemoteException;

    public void setOnPoiClickListener(zzu var1) throws RemoteException;

    public void onEnterAmbient(Bundle var1) throws RemoteException;

    public void onExitAmbient() throws RemoteException;

    public void setOnGroundOverlayClickListener(zzg var1) throws RemoteException;

    public void setOnInfoWindowLongClickListener(zzk var1) throws RemoteException;

    public void setOnPolygonClickListener(zzv var1) throws RemoteException;

    public void setOnInfoWindowCloseListener(zzj var1) throws RemoteException;

    public void setOnPolylineClickListener(zzw var1) throws RemoteException;

    public void setOnCircleClickListener(zzf var1) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IGoogleMapDelegate$zza
    extends Binder
    implements IGoogleMapDelegate {
        public static IGoogleMapDelegate zzhi(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
            if (iInterface != null && iInterface instanceof IGoogleMapDelegate) {
                return (IGoogleMapDelegate)iInterface;
            }
            return new zza(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    return true;
                }
                case 1: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraPosition cameraPosition = this.getCameraPosition();
                    parcel2.writeNoException();
                    if (cameraPosition != null) {
                        parcel2.writeInt(1);
                        cameraPosition.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f = this.getMaxZoomLevel();
                    parcel2.writeNoException();
                    parcel2.writeFloat(f);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f = this.getMinZoomLevel();
                    parcel2.writeNoException();
                    parcel2.writeFloat(f);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd2 = zzd.zza.zzfc((IBinder)parcel.readStrongBinder());
                    this.moveCamera(zzd2);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd3 = zzd.zza.zzfc((IBinder)parcel.readStrongBinder());
                    this.animateCamera(zzd3);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd4 = zzd.zza.zzfc((IBinder)parcel.readStrongBinder());
                    zzb zzb2 = zzb.zza.zzhg(parcel.readStrongBinder());
                    this.animateCameraWithCallback(zzd4, zzb2);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd5 = zzd.zza.zzfc((IBinder)parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    zzb zzb3 = zzb.zza.zzhg(parcel.readStrongBinder());
                    this.animateCameraWithDurationAndCallback(zzd5, n3, zzb3);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.stopAnimation();
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolylineOptions polylineOptions = 0 != parcel.readInt() ? (PolylineOptions)PolylineOptions.CREATOR.createFromParcel(parcel) : null;
                    IPolylineDelegate iPolylineDelegate = this.addPolyline(polylineOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iPolylineDelegate != null ? iPolylineDelegate.asBinder() : null);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolygonOptions polygonOptions = 0 != parcel.readInt() ? (PolygonOptions)PolygonOptions.CREATOR.createFromParcel(parcel) : null;
                    com.google.android.gms.maps.model.internal.zzg zzg2 = this.addPolygon(polygonOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzg2 != null ? zzg2.asBinder() : null);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != parcel.readInt() ? (MarkerOptions)MarkerOptions.CREATOR.createFromParcel(parcel) : null;
                    com.google.android.gms.maps.model.internal.zzf zzf2 = this.addMarker(markerOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzf2 != null ? zzf2.asBinder() : null);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != parcel.readInt() ? (GroundOverlayOptions)GroundOverlayOptions.CREATOR.createFromParcel(parcel) : null;
                    zzc zzc2 = this.addGroundOverlay(groundOverlayOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzc2 != null ? zzc2.asBinder() : null);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    TileOverlayOptions tileOverlayOptions = 0 != parcel.readInt() ? (TileOverlayOptions)TileOverlayOptions.CREATOR.createFromParcel(parcel) : null;
                    com.google.android.gms.maps.model.internal.zzh zzh2 = this.addTileOverlay(tileOverlayOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzh2 != null ? zzh2.asBinder() : null);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.clear();
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n4 = this.getMapType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n5 = parcel.readInt();
                    this.setMapType(n5);
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isTrafficEnabled();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != parcel.readInt();
                    this.setTrafficEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isIndoorEnabled();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != parcel.readInt();
                    boolean bl2 = this.setIndoorEnabled(bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isMyLocationEnabled();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != parcel.readInt();
                    this.setMyLocationEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Location location = this.getMyLocation();
                    parcel2.writeNoException();
                    if (location != null) {
                        parcel2.writeInt(1);
                        location.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ILocationSourceDelegate iLocationSourceDelegate = ILocationSourceDelegate.zza.zzhk(parcel.readStrongBinder());
                    this.setLocationSource(iLocationSourceDelegate);
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IUiSettingsDelegate iUiSettingsDelegate = this.getUiSettings();
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iUiSettingsDelegate != null ? iUiSettingsDelegate.asBinder() : null);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IProjectionDelegate iProjectionDelegate = this.getProjection();
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iProjectionDelegate != null ? iProjectionDelegate.asBinder() : null);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zze zze2 = zze.zza.zzhn(parcel.readStrongBinder());
                    this.setOnCameraChangeListener(zze2);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzm zzm2 = zzm.zza.zzhv(parcel.readStrongBinder());
                    this.setOnMapClickListener(zzm2);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzo zzo2 = zzo.zza.zzhx(parcel.readStrongBinder());
                    this.setOnMapLongClickListener(zzo2);
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzq zzq2 = zzq.zza.zzhz(parcel.readStrongBinder());
                    this.setOnMarkerClickListener(zzq2);
                    parcel2.writeNoException();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzr zzr2 = zzr.zza.zzia(parcel.readStrongBinder());
                    this.setOnMarkerDragListener(zzr2);
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzi zzi2 = zzi.zza.zzhr(parcel.readStrongBinder());
                    this.setOnInfoWindowClickListener(zzi2);
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzd zzd6 = zzd.zza.zzhj(parcel.readStrongBinder());
                    this.setInfoWindowAdapter(zzd6);
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CircleOptions circleOptions = 0 != parcel.readInt() ? (CircleOptions)CircleOptions.CREATOR.createFromParcel(parcel) : null;
                    com.google.android.gms.maps.model.internal.zzb zzb4 = this.addCircle(circleOptions);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzb4 != null ? zzb4.asBinder() : null);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzt zzt2 = zzt.zza.zzic(parcel.readStrongBinder());
                    this.setOnMyLocationChangeListener(zzt2);
                    parcel2.writeNoException();
                    return true;
                }
                case 37: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzs zzs2 = zzs.zza.zzib(parcel.readStrongBinder());
                    this.setOnMyLocationButtonClickListener(zzs2);
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzac zzac2 = zzac.zza.zzim(parcel.readStrongBinder());
                    com.google.android.gms.dynamic.zzd zzd7 = zzd.zza.zzfc((IBinder)parcel.readStrongBinder());
                    this.snapshot(zzac2, zzd7);
                    parcel2.writeNoException();
                    return true;
                }
                case 39: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    int n9 = parcel.readInt();
                    this.setPadding(n6, n7, n8, n9);
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isBuildingsEnabled();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != parcel.readInt();
                    this.setBuildingsEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzn zzn2 = zzn.zza.zzhw(parcel.readStrongBinder());
                    this.setOnMapLoadedCallback(zzn2);
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.maps.model.internal.zzd zzd8 = this.getFocusedBuilding();
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(zzd8 != null ? zzd8.asBinder() : null);
                    return true;
                }
                case 45: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzh zzh3 = zzh.zza.zzhq(parcel.readStrongBinder());
                    this.setOnIndoorStateChangeListener(zzh3);
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != parcel.readInt();
                    this.setWatermarkEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzp zzp2 = zzp.zza.zzhy(parcel.readStrongBinder());
                    this.getMapAsync(zzp2);
                    parcel2.writeNoException();
                    return true;
                }
                case 54: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != parcel.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.onCreate(bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onResume();
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onPause();
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onDestroy();
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onLowMemory();
                    parcel2.writeNoException();
                    return true;
                }
                case 59: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.useViewLifecycleWhenInFragment();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 60: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != parcel.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.onSaveInstanceState(bundle);
                    parcel2.writeNoException();
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 61: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    String string = parcel.readString();
                    this.setContentDescription(string);
                    parcel2.writeNoException();
                    return true;
                }
                case 71: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzac zzac3 = zzac.zza.zzim(parcel.readStrongBinder());
                    this.snapshotForTest(zzac3);
                    parcel2.writeNoException();
                    return true;
                }
                case 80: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzu zzu2 = zzu.zza.zzid(parcel.readStrongBinder());
                    this.setOnPoiClickListener(zzu2);
                    parcel2.writeNoException();
                    return true;
                }
                case 81: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != parcel.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.onEnterAmbient(bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 82: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onExitAmbient();
                    parcel2.writeNoException();
                    return true;
                }
                case 83: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzg zzg3 = zzg.zza.zzhp(parcel.readStrongBinder());
                    this.setOnGroundOverlayClickListener(zzg3);
                    parcel2.writeNoException();
                    return true;
                }
                case 84: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzk zzk2 = zzk.zza.zzht(parcel.readStrongBinder());
                    this.setOnInfoWindowLongClickListener(zzk2);
                    parcel2.writeNoException();
                    return true;
                }
                case 85: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzv zzv2 = zzv.zza.zzie(parcel.readStrongBinder());
                    this.setOnPolygonClickListener(zzv2);
                    parcel2.writeNoException();
                    return true;
                }
                case 86: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzj zzj2 = zzj.zza.zzhs(parcel.readStrongBinder());
                    this.setOnInfoWindowCloseListener(zzj2);
                    parcel2.writeNoException();
                    return true;
                }
                case 87: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzw zzw2 = zzw.zza.zzif(parcel.readStrongBinder());
                    this.setOnPolylineClickListener(zzw2);
                    parcel2.writeNoException();
                    return true;
                }
                case 89: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzf zzf3 = zzf.zza.zzho(parcel.readStrongBinder());
                    this.setOnCircleClickListener(zzf3);
                    parcel2.writeNoException();
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class zza
        implements IGoogleMapDelegate {
            private IBinder zzahn;

            zza(IBinder iBinder) {
                this.zzahn = iBinder;
            }

            public IBinder asBinder() {
                return this.zzahn;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraPosition getCameraPosition() throws RemoteException {
                CameraPosition cameraPosition;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    cameraPosition = 0 != parcel2.readInt() ? (CameraPosition)((Object)CameraPosition.CREATOR.createFromParcel(parcel2)) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return cameraPosition;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMaxZoomLevel() throws RemoteException {
                float f;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    f = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMinZoomLevel() throws RemoteException {
                float f;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    f = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera(com.google.android.gms.dynamic.zzd zzd2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    this.zzahn.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera(com.google.android.gms.dynamic.zzd zzd2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    this.zzahn.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback(com.google.android.gms.dynamic.zzd zzd2, zzb zzb2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    parcel.writeStrongBinder(zzb2 != null ? zzb2.asBinder() : null);
                    this.zzahn.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.zzd zzd2, int n, zzb zzb2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(zzb2 != null ? zzb2.asBinder() : null);
                    this.zzahn.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopAnimation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPolylineDelegate addPolyline(PolylineOptions polylineOptions) throws RemoteException {
                IPolylineDelegate iPolylineDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (polylineOptions != null) {
                        parcel.writeInt(1);
                        polylineOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iPolylineDelegate = IPolylineDelegate.zza.zziy(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPolylineDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzg addPolygon(PolygonOptions polygonOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzg zzg2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (polygonOptions != null) {
                        parcel.writeInt(1);
                        polygonOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    zzg2 = zzg.zza.zzix(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzg2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzf addMarker(MarkerOptions markerOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzf zzf2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (markerOptions != null) {
                        parcel.writeInt(1);
                        markerOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    zzf2 = zzf.zza.zziw(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzf2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzc addGroundOverlay(GroundOverlayOptions groundOverlayOptions) throws RemoteException {
                zzc zzc2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (groundOverlayOptions != null) {
                        parcel.writeInt(1);
                        groundOverlayOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    zzc2 = zzc.zza.zzit(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzc2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzh addTileOverlay(TileOverlayOptions tileOverlayOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzh zzh2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (tileOverlayOptions != null) {
                        parcel.writeInt(1);
                        tileOverlayOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    zzh2 = zzh.zza.zziz(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzh2;
            }

            @Override
            public void clear() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMapType() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMapType(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(n);
                    this.zzahn.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrafficEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrafficEnabled(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(bl ? 1 : 0);
                    this.zzahn.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIndoorEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setIndoorEnabled(boolean bl) throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(bl ? 1 : 0);
                    this.zzahn.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMyLocationEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMyLocationEnabled(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(bl ? 1 : 0);
                    this.zzahn.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getMyLocation() throws RemoteException {
                Location location;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    location = 0 != parcel2.readInt() ? (Location)Location.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return location;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationSource(ILocationSourceDelegate iLocationSourceDelegate) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(iLocationSourceDelegate != null ? iLocationSourceDelegate.asBinder() : null);
                    this.zzahn.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IUiSettingsDelegate getUiSettings() throws RemoteException {
                IUiSettingsDelegate iUiSettingsDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    iUiSettingsDelegate = IUiSettingsDelegate.zza.zziq(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iUiSettingsDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IProjectionDelegate getProjection() throws RemoteException {
                IProjectionDelegate iProjectionDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    iProjectionDelegate = IProjectionDelegate.zza.zzil(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iProjectionDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnCameraChangeListener(zze zze2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zze2 != null ? zze2.asBinder() : null);
                    this.zzahn.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapClickListener(zzm zzm2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzm2 != null ? zzm2.asBinder() : null);
                    this.zzahn.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLongClickListener(zzo zzo2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzo2 != null ? zzo2.asBinder() : null);
                    this.zzahn.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerClickListener(zzq zzq2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzq2 != null ? zzq2.asBinder() : null);
                    this.zzahn.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerDragListener(zzr zzr2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzr2 != null ? zzr2.asBinder() : null);
                    this.zzahn.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowClickListener(zzi zzi2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzi2 != null ? zzi2.asBinder() : null);
                    this.zzahn.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowAdapter(zzd zzd2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    this.zzahn.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzb addCircle(CircleOptions circleOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzb zzb2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (circleOptions != null) {
                        parcel.writeInt(1);
                        circleOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    zzb2 = zzb.zza.zzis(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzb2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationChangeListener(zzt zzt2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzt2 != null ? zzt2.asBinder() : null);
                    this.zzahn.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationButtonClickListener(zzs zzs2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzs2 != null ? zzs2.asBinder() : null);
                    this.zzahn.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snapshot(zzac zzac2, com.google.android.gms.dynamic.zzd zzd2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzac2 != null ? zzac2.asBinder() : null);
                    parcel.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    this.zzahn.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPadding(int n, int n2, int n3, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    this.zzahn.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBuildingsEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBuildingsEnabled(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(bl ? 1 : 0);
                    this.zzahn.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLoadedCallback(zzn zzn2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzn2 != null ? zzn2.asBinder() : null);
                    this.zzahn.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzd getFocusedBuilding() throws RemoteException {
                com.google.android.gms.maps.model.internal.zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zziu(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnIndoorStateChangeListener(zzh zzh2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzh2 != null ? zzh2.asBinder() : null);
                    this.zzahn.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWatermarkEnabled(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(bl ? 1 : 0);
                    this.zzahn.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMapAsync(zzp zzp2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzp2 != null ? zzp2.asBinder() : null);
                    this.zzahn.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreate(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void onResume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void onPause() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void onDestroy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void onLowMemory() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useViewLifecycleWhenInFragment() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaveInstanceState(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        bundle.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setContentDescription(String string) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeString(string);
                    this.zzahn.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snapshotForTest(zzac zzac2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzac2 != null ? zzac2.asBinder() : null);
                    this.zzahn.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnPoiClickListener(zzu zzu2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzu2 != null ? zzu2.asBinder() : null);
                    this.zzahn.transact(80, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnterAmbient(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzahn.transact(81, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void onExitAmbient() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zzahn.transact(82, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnGroundOverlayClickListener(zzg zzg2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzg2 != null ? zzg2.asBinder() : null);
                    this.zzahn.transact(83, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowLongClickListener(zzk zzk2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzk2 != null ? zzk2.asBinder() : null);
                    this.zzahn.transact(84, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnPolygonClickListener(zzv zzv2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzv2 != null ? zzv2.asBinder() : null);
                    this.zzahn.transact(85, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowCloseListener(zzj zzj2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzj2 != null ? zzj2.asBinder() : null);
                    this.zzahn.transact(86, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnPolylineClickListener(zzw zzw2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzw2 != null ? zzw2.asBinder() : null);
                    this.zzahn.transact(87, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnCircleClickListener(zzf zzf2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(zzf2 != null ? zzf2.asBinder() : null);
                    this.zzahn.transact(89, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

