/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzad {
    private static Context zzbak;
    private static zzc zzbal;

    public static zzc zzaZ(Context context) throws GooglePlayServicesNotAvailableException {
        zzaa.zzz((Object)context);
        if (zzbal != null) {
            return zzbal;
        }
        zzad.zzba(context);
        zzbal = zzad.zzbb(context);
        try {
            zzbal.zzd(zze.zzD((Object)zzad.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzbal;
    }

    public static boolean zzDQ() {
        return false;
    }

    private static Class<?> zzDR() {
        try {
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzba(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzbb(Context context) {
        if (zzad.zzDQ()) {
            Log.i((String)zzad.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzad.zzDR();
            return (zzc)zzad.zzf(clazz);
        }
        Log.i((String)zzad.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzad.zza(zzad.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzcC(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzbak == null) {
            zzbak = zzad.zzDQ() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzbak;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzad.zzf(((ClassLoader)zzaa.zzz((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zzf(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

