/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int mVersionCode;
    private final List<LatLng> zzaQL;
    private final List<List<LatLng>> zzaQM;
    private float zzaQg = 10.0f;
    private int zzaQh = -16777216;
    private int zzaQi = 0;
    private float zzaQj = 0.0f;
    private boolean zzaQk = true;
    private boolean zzaQN = false;

    public PolygonOptions() {
        this.mVersionCode = 1;
        this.zzaQL = new ArrayList<LatLng>();
        this.zzaQM = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.mVersionCode = versionCode;
        this.zzaQL = points;
        this.zzaQM = holes;
        this.zzaQg = strokeWidth;
        this.zzaQh = strokeColor;
        this.zzaQi = fillColor;
        this.zzaQj = zIndex;
        this.zzaQk = visible;
        this.zzaQN = geodesic;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List zzzw() {
        return this.zzaQM;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzaQL.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzaQL.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaQL.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzaQM.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaQg = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzaQh = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzaQi = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzaQj = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzaQk = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzaQN = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaQL;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzaQM;
    }

    public float getStrokeWidth() {
        return this.zzaQg;
    }

    public int getStrokeColor() {
        return this.zzaQh;
    }

    public int getFillColor() {
        return this.zzaQi;
    }

    public float getZIndex() {
        return this.zzaQj;
    }

    public boolean isVisible() {
        return this.zzaQk;
    }

    public boolean isGeodesic() {
        return this.zzaQN;
    }
}

