/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzaPR = new zzb(this);
    private GoogleMap zzaPf;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate zzzg() {
        this.zzaPR.zzzh();
        if (this.zzaPR.zzts() == null) {
            return null;
        }
        return ((zza)this.zzaPR.zzts()).zzzg();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zzzg();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzaPf == null || this.zzaPf.zzyU().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzaPf = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzaPf;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzaPR.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zzaPR.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzaPR.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzaPR.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.zzaPR.onCreateView(inflater, container, savedInstanceState);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzaPR.onResume();
    }

    public void onPause() {
        this.zzaPR.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzaPR.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzaPR.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzaPR.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zzaPR.onSaveInstanceState(outState);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        com.google.android.gms.common.internal.zzx.zzcx((String)"onEnterAmbient must be called on the main thread.");
        this.zzaPR.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        com.google.android.gms.common.internal.zzx.zzcx((String)"onExitAmbient must be called on the main thread.");
        this.zzaPR.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        com.google.android.gms.common.internal.zzx.zzcx((String)"getMapAsync must be called on the main thread.");
        this.zzaPR.getMapAsync(callback);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzajv;
        protected zzf<zza> zzaPj;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzaPk = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzajv = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaPj = zzf2;
            this.zzzh();
        }

        public void zzzh() {
            if (this.mActivity != null && this.zzaPj != null && this.zzts() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzy.zzaP((Context)this.mActivity).zzt(zze.zzB((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzaPj.zza((LifecycleDelegate)new zza(this.zzajv, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaPk) {
                        ((zza)this.zzts()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaPk.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzzh();
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzts() != null) {
                ((zza)this.zzts()).getMapAsync(callback);
            } else {
                this.zzaPk.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zzts() != null) {
                ((zza)this.zzts()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zzts() != null) {
                ((zza)this.zzts()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzajv;
        private final IMapFragmentDelegate zzaPg;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzaPg = (IMapFragmentDelegate)com.google.android.gms.common.internal.zzx.zzy((Object)iMapFragmentDelegate);
            this.zzajv = (Fragment)com.google.android.gms.common.internal.zzx.zzy((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.zzaPg.onInflate(zze.zzB((Object)activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.zzajv.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    zzx.zza(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.zzaPg.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            zzd zzd2;
            try {
                zzd2 = this.zzaPg.onCreateView(zze.zzB((Object)inflater), zze.zzB((Object)container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzp((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaPg.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaPg.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.zzaPg.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzaPg.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaPg.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaPg.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zzzg() {
            return this.zzaPg;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaPg.getMapAsync(new zzl.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaPg.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaPg.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

