/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaPl;
    private GoogleMap zzaPf;

    public MapView(Context context) {
        super(context);
        this.zzaPl = new zzb((ViewGroup)this, context, null);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaPl = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaPl = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaPl = new zzb((ViewGroup)this, context, options);
        this.init();
    }

    private void init() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaPf != null) {
            return this.zzaPf;
        }
        this.zzaPl.zzzh();
        if (this.zzaPl.zzts() == null) {
            return null;
        }
        try {
            this.zzaPf = new GoogleMap(((zza)this.zzaPl.zzts()).zzzi().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaPf;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaPl.onCreate(savedInstanceState);
        if (this.zzaPl.zzts() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaPl.onResume();
    }

    public final void onPause() {
        this.zzaPl.onPause();
    }

    public final void onDestroy() {
        this.zzaPl.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaPl.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaPl.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzx.zzcx((String)"getMapAsync() must be called on the main thread");
        this.zzaPl.getMapAsync(callback);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        zzx.zzcx((String)"onEnterAmbient() must be called on the main thread");
        this.zzaPl.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        zzx.zzcx((String)"onExitAmbient() must be called on the main thread");
        this.zzaPl.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaPq;
        private final Context mContext;
        protected zzf<zza> zzaPj;
        private final GoogleMapOptions zzaPr;
        private final List<OnMapReadyCallback> zzaPk = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaPq = viewGroup;
            this.mContext = context;
            this.zzaPr = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaPj = zzf2;
            this.zzzh();
        }

        public void zzzh() {
            if (this.zzaPj != null && this.zzts() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzy.zzaP(this.mContext).zza(zze.zzB((Object)this.mContext), this.zzaPr);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaPj.zza((LifecycleDelegate)new zza(this.zzaPq, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaPk) {
                        ((zza)this.zzts()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaPk.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzts() != null) {
                ((zza)this.zzts()).getMapAsync(callback);
            } else {
                this.zzaPk.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zzts() != null) {
                ((zza)this.zzts()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zzts() != null) {
                ((zza)this.zzts()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaPm;
        private final IMapViewDelegate zzaPn;
        private View zzaPo;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaPn = (IMapViewDelegate)zzx.zzy((Object)iMapViewDelegate);
            this.zzaPm = (ViewGroup)zzx.zzy((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaPn.onCreate(savedInstanceState);
                this.zzaPo = (View)zze.zzp((zzd)this.zzaPn.getView());
                this.zzaPm.removeAllViews();
                this.zzaPm.addView(this.zzaPo);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaPn.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaPn.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaPn.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaPn.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaPn.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzzi() {
            return this.zzaPn;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaPn.getMapAsync(new zzl.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaPn.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaPn.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

