/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zze;
import com.google.android.gms.maps.model.zzf;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    public static final float NO_DIMENSION = -1.0f;
    private final int zzFG;
    private BitmapDescriptor zzare;
    private LatLng zzarf;
    private float zzarg;
    private float zzarh;
    private LatLngBounds zzari;
    private float zzaqU;
    private float zzarb;
    private boolean zzarc = true;
    private float zzarj = 0.0f;
    private float zzark = 0.5f;
    private float zzarl = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.zzFG = versionCode;
        this.zzare = new BitmapDescriptor(zzd.zza.zzau((IBinder)wrappedImage));
        this.zzarf = location;
        this.zzarg = width;
        this.zzarh = height;
        this.zzari = bounds;
        this.zzaqU = bearing;
        this.zzarb = zIndex;
        this.zzarc = visible;
        this.zzarj = transparency;
        this.zzark = anchorU;
        this.zzarl = anchorV;
    }

    public GroundOverlayOptions() {
        this.zzFG = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzf.zza(this, out, flags);
        } else {
            zze.zza(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzqH() {
        return this.zzare.zzqe().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzare = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzark = u;
        this.zzarl = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzx.zza((this.zzari == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzx.zza((this.zzari == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzx.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzarf = latLng;
        this.zzarg = f;
        this.zzarh = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzx.zza((this.zzarf == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzarf));
        this.zzari = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzaqU = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzarb = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzarc = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzx.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzarj = transparency;
        return this;
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public BitmapDescriptor getImage() {
        return this.zzare;
    }

    public LatLng getLocation() {
        return this.zzarf;
    }

    public float getWidth() {
        return this.zzarg;
    }

    public float getHeight() {
        return this.zzarh;
    }

    public LatLngBounds getBounds() {
        return this.zzari;
    }

    public float getBearing() {
        return this.zzaqU;
    }

    public float getZIndex() {
        return this.zzarb;
    }

    public float getTransparency() {
        return this.zzarj;
    }

    public float getAnchorU() {
        return this.zzark;
    }

    public float getAnchorV() {
        return this.zzarl;
    }

    public boolean isVisible() {
        return this.zzarc;
    }
}

