/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CameraPositionCreator")
public final class CameraPosition
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<CameraPosition> CREATOR;
    @SafeParcelable.Field(id=2)
    @NonNull
    public final LatLng target;
    @SafeParcelable.Field(id=3)
    public final float zoom;
    @SafeParcelable.Field(id=4)
    public final float tilt;
    @SafeParcelable.Field(id=5)
    public final float bearing;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @NonNull
    public static Builder builder(@NonNull CameraPosition camera) {
        CameraPosition cameraPosition;
        Builder builder = new Builder(cameraPosition);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static CameraPosition createFromAttributes(@Nullable Context context, @Nullable AttributeSet attrs) {
        void var1_1;
        return GoogleMapOptions.zza(context, (AttributeSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static final CameraPosition fromLatLngZoom(@NonNull LatLng target, float zoom) {
        void var1_1;
        LatLng latLng;
        CameraPosition cameraPosition = new CameraPosition(latLng, (float)var1_1, 0.0f, 0.0f);
        return cameraPosition;
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("target", (Object)this.target).add("zoom", (Object)Float.valueOf(this.zoom)).add("tilt", (Object)Float.valueOf(this.tilt)).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public CameraPosition(@SafeParcelable.Param(id=2) @NonNull LatLng target, @SafeParcelable.Param(id=3) float zoom, @SafeParcelable.Param(id=4) float tilt, @SafeParcelable.Param(id=5) float bearing) {
        void var4_5;
        void var2_3;
        void var3_4;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"camera target must not be null.");
        boolean bl = !(var3_4 < 0.0f) ? var3_4 <= 90.0f : false;
        Object[] objectArray = new Object[]{Float.valueOf((float)var3_4)};
        Preconditions.checkArgument((boolean)bl, (String)"Tilt needs to be between 0 and 90 inclusive: %s", (Object[])objectArray);
        this.target = var1_1;
        this.zoom = var2_3;
        this.tilt = var3_4 + 0.0f;
        void var1_2 = (double)var4_5 <= 0.0 ? var4_5 % 360.0f + 360.0f : var4_5;
        this.bearing = var1_2 % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.target, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.zoom);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.tilt);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)5, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        CameraPosition cameraPosition;
        if (this == cameraPosition) {
            return true;
        }
        if (!(cameraPosition instanceof CameraPosition)) {
            return false;
        }
        cameraPosition = cameraPosition;
        return this.target.equals((Object)cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public static final class Builder {
        private LatLng zza;
        private float zzb;
        private float zzc;
        private float zzd;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder target(@NonNull LatLng location) {
            void var1_1;
            this.zza = (LatLng)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"location must not be null."));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder zoom(float zoom) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public CameraPosition build() {
            CameraPosition cameraPosition = new CameraPosition(this.zza, this.zzb, this.zzc, this.zzd);
            return cameraPosition;
        }

        public Builder() {
        }

        public Builder(@NonNull CameraPosition previous) {
            CameraPosition cameraPosition;
            cameraPosition = (CameraPosition)((Object)Preconditions.checkNotNull((Object)((Object)cameraPosition), (Object)"previous must not be null."));
            this.zza = cameraPosition.target;
            this.zzb = cameraPosition.zoom;
            this.zzc = cameraPosition.tilt;
            this.zzd = cameraPosition.bearing;
        }
    }
}

