/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.VisibleRegion;

public final class Projection {
    private final IProjectionDelegate zza;

    @NonNull
    public Point toScreenLocation(@NonNull LatLng location) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)((Object)location));
        try {
            Projection projection = (Point)ObjectWrapper.unwrap((IObjectWrapper)projection.zza.toScreenLocation((LatLng)((Object)runtimeRemoteException)));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return projection;
    }

    @NonNull
    public LatLng fromScreenLocation(@NonNull Point point) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)point);
        try {
            Object object = object.zza.fromScreenLocation(ObjectWrapper.wrap((Object)runtimeRemoteException));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return object;
    }

    @NonNull
    public VisibleRegion getVisibleRegion() {
        try {
            Object this_ = this_.zza.getVisibleRegion();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    Projection(IProjectionDelegate iProjectionDelegate) {
        this.zza = iProjectionDelegate;
    }
}

