/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzq;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaOrientationCreator")
public class StreetViewPanoramaOrientation
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<StreetViewPanoramaOrientation> CREATOR;
    @SafeParcelable.Field(id=2)
    public final float tilt;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public StreetViewPanoramaOrientation(@SafeParcelable.Param(id=2) float tilt, @SafeParcelable.Param(id=3) float bearing) {
        void var2_2;
        void var1_1;
        boolean bl = !(var1_1 < -90.0f) ? var1_1 <= 90.0f : false;
        StringBuilder stringBuilder = new StringBuilder(62);
        stringBuilder.append("Tilt needs to be between -90 and 90 inclusive: ");
        stringBuilder.append((float)var1_1);
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.tilt = var1_1 + 0.0f;
        var1_1 = (double)var2_2 <= 0.0 ? var2_2 % 360.0f + 360.0f : var2_2;
        this.bearing = var1_1 % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)2, (float)this.tilt);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @RecentlyNonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @RecentlyNonNull
    public static Builder builder(@RecentlyNonNull StreetViewPanoramaOrientation orientation) {
        StreetViewPanoramaOrientation streetViewPanoramaOrientation;
        Builder builder = new Builder(streetViewPanoramaOrientation);
        return builder;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaOrientation streetViewPanoramaOrientation;
        if (this == streetViewPanoramaOrientation) {
            return true;
        }
        if (!(streetViewPanoramaOrientation instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        streetViewPanoramaOrientation = streetViewPanoramaOrientation;
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    @RecentlyNonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("tilt", (Object)Float.valueOf(this.tilt)).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    static {
        zzq zzq2;
        CREATOR = zzq2 = new zzq();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@RecentlyNonNull StreetViewPanoramaOrientation previous) {
            void var1_1;
            Preconditions.checkNotNull((Object)var1_1, (Object)"StreetViewPanoramaOrientation must not be null.");
            this.bearing = var1_1.bearing;
            this.tilt = var1_1.tilt;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.tilt = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.bearing = var1_1;
            return this;
        }

        @RecentlyNonNull
        public StreetViewPanoramaOrientation build() {
            StreetViewPanoramaOrientation streetViewPanoramaOrientation = new StreetViewPanoramaOrientation(this.tilt, this.bearing);
            return streetViewPanoramaOrientation;
        }
    }
}

