/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.zzn;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaCameraCreator")
public class StreetViewPanoramaCamera
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<StreetViewPanoramaCamera> CREATOR;
    @SafeParcelable.Field(id=2)
    public final float zoom;
    @SafeParcelable.Field(id=3)
    public final float tilt;
    @SafeParcelable.Field(id=4)
    public final float bearing;
    private final StreetViewPanoramaOrientation zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public StreetViewPanoramaCamera(@SafeParcelable.Param(id=2) float zoom, @SafeParcelable.Param(id=3) float tilt, @SafeParcelable.Param(id=4) float bearing) {
        void var3_4;
        float f;
        void var2_3;
        boolean bl = !(var2_3 < -90.0f) ? var2_3 <= 90.0f : false;
        StringBuilder stringBuilder = new StringBuilder(62);
        stringBuilder.append("Tilt needs to be between -90 and 90 inclusive: ");
        stringBuilder.append((float)var2_3);
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        if ((double)f <= 0.0) {
            f = 0.0f;
        }
        this.zoom = f;
        this.tilt = var2_3 + 0.0f;
        f = (double)var3_4 <= 0.0 ? var3_4 % 360.0f + 360.0f : var3_4;
        this.bearing = f % 360.0f;
        StreetViewPanoramaOrientation.Builder builder = new StreetViewPanoramaOrientation.Builder();
        builder.tilt((float)var2_3);
        builder.bearing((float)var3_4);
        this.zza = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)2, (float)this.zoom);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.tilt);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @RecentlyNonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @RecentlyNonNull
    public static Builder builder(@RecentlyNonNull StreetViewPanoramaCamera camera) {
        StreetViewPanoramaCamera streetViewPanoramaCamera;
        Builder builder = new Builder(streetViewPanoramaCamera);
        return builder;
    }

    @RecentlyNonNull
    public StreetViewPanoramaOrientation getOrientation() {
        return this.zza;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaCamera streetViewPanoramaCamera;
        if (this == streetViewPanoramaCamera) {
            return true;
        }
        if (!(streetViewPanoramaCamera instanceof StreetViewPanoramaCamera)) {
            return false;
        }
        streetViewPanoramaCamera = streetViewPanoramaCamera;
        return Float.floatToIntBits(this.zoom) == Float.floatToIntBits(streetViewPanoramaCamera.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaCamera.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaCamera.bearing);
    }

    @RecentlyNonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("zoom", (Object)Float.valueOf(this.zoom)).add("tilt", (Object)Float.valueOf(this.tilt)).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    static {
        zzn zzn2;
        CREATOR = zzn2 = new zzn();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;
        public float zoom;

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@RecentlyNonNull StreetViewPanoramaCamera previous) {
            void var1_1;
            Preconditions.checkNotNull((Object)var1_1, (Object)"StreetViewPanoramaCamera must not be null.");
            this.zoom = var1_1.zoom;
            this.bearing = var1_1.bearing;
            this.tilt = var1_1.tilt;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder zoom(float zoom) {
            void var1_1;
            this.zoom = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder orientation(@RecentlyNonNull StreetViewPanoramaOrientation orientation) {
            void var1_1;
            Preconditions.checkNotNull((Object)((Object)orientation), (Object)"orientation must not be null.");
            this.tilt = var1_1.tilt;
            this.bearing = var1_1.bearing;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.tilt = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.bearing = var1_1;
            return this;
        }

        @RecentlyNonNull
        public StreetViewPanoramaCamera build() {
            StreetViewPanoramaCamera streetViewPanoramaCamera = new StreetViewPanoramaCamera(this.zoom, this.tilt, this.bearing);
            return streetViewPanoramaCamera;
        }
    }
}

