/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.internal.zzca;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import javax.annotation.concurrent.GuardedBy;

public final class MapsInitializer {
    @GuardedBy(value="MapsInitializer.class")
    private static boolean zza = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized int initialize(@RecentlyNonNull Context context) {
        zzf zzf2;
        Preconditions.checkNotNull((Object)context, (Object)"Context is null");
        if (zza) return 0;
        try {
            zzf2 = zzca.zza((Context)zzf2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            return googlePlayServicesNotAvailableException.errorCode;
        }
        try {
            CameraUpdateFactory.zza(zzf2.zzf());
            BitmapDescriptorFactory.zza(zzf2.zzg());
            zza = true;
            return 0;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    private MapsInitializer() {
    }
}

