/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.R;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzab;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GoogleMapOptionsCreator")
public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR;
    @SafeParcelable.Field(id=2, getter="getZOrderOnTopForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zza;
    @SafeParcelable.Field(id=3, getter="getUseViewLifecycleInFragmentForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzb;
    @SafeParcelable.Field(id=4, getter="getMapType")
    private int zzc = -1;
    @SafeParcelable.Field(id=5, getter="getCamera")
    @Nullable
    private CameraPosition zzd;
    @SafeParcelable.Field(id=6, getter="getZoomControlsEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zze;
    @SafeParcelable.Field(id=7, getter="getCompassEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzf;
    @SafeParcelable.Field(id=8, getter="getScrollGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzg;
    @SafeParcelable.Field(id=9, getter="getZoomGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzh;
    @SafeParcelable.Field(id=10, getter="getTiltGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzi;
    @SafeParcelable.Field(id=11, getter="getRotateGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzj;
    @SafeParcelable.Field(id=12, getter="getLiteModeForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzk;
    @SafeParcelable.Field(id=14, getter="getMapToolbarEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzl;
    @SafeParcelable.Field(id=15, getter="getAmbientEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzm;
    @SafeParcelable.Field(id=16, getter="getMinZoomPreference")
    @Nullable
    private Float zzn = null;
    @SafeParcelable.Field(id=17, getter="getMaxZoomPreference")
    @Nullable
    private Float zzo = null;
    @SafeParcelable.Field(id=18, getter="getLatLngBoundsForCameraTarget")
    @Nullable
    private LatLngBounds zzp = null;
    @SafeParcelable.Field(id=19, getter="getScrollGesturesEnabledDuringRotateOrZoomForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzq;

    @SafeParcelable.Constructor
    GoogleMapOptions(@SafeParcelable.Param(id=2) byte by, @SafeParcelable.Param(id=3) byte by2, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) @Nullable CameraPosition cameraPosition, @SafeParcelable.Param(id=6) byte by3, @SafeParcelable.Param(id=7) byte by4, @SafeParcelable.Param(id=8) byte by5, @SafeParcelable.Param(id=9) byte by6, @SafeParcelable.Param(id=10) byte by7, @SafeParcelable.Param(id=11) byte by8, @SafeParcelable.Param(id=12) byte by9, @SafeParcelable.Param(id=14) byte by10, @SafeParcelable.Param(id=15) byte by11, @SafeParcelable.Param(id=16) @Nullable Float f, @SafeParcelable.Param(id=17) @Nullable Float f2, @SafeParcelable.Param(id=18) @Nullable LatLngBounds latLngBounds, @SafeParcelable.Param(id=19) byte by12) {
        this.zza = com.google.android.gms.maps.internal.zza.zza(by);
        this.zzb = com.google.android.gms.maps.internal.zza.zza(by2);
        this.zzc = n;
        this.zzd = cameraPosition;
        this.zze = com.google.android.gms.maps.internal.zza.zza(by3);
        this.zzf = com.google.android.gms.maps.internal.zza.zza(by4);
        this.zzg = com.google.android.gms.maps.internal.zza.zza(by5);
        this.zzh = com.google.android.gms.maps.internal.zza.zza(by6);
        this.zzi = com.google.android.gms.maps.internal.zza.zza(by7);
        this.zzj = com.google.android.gms.maps.internal.zza.zza(by8);
        this.zzk = com.google.android.gms.maps.internal.zza.zza(by9);
        this.zzl = com.google.android.gms.maps.internal.zza.zza(by10);
        this.zzm = com.google.android.gms.maps.internal.zza.zza(by11);
        this.zzn = f;
        this.zzo = f2;
        this.zzp = latLngBounds;
        this.zzq = com.google.android.gms.maps.internal.zza.zza(by12);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)2, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zza));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)3, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzb));
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getMapType());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getCamera(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)6, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zze));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)7, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzf));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)8, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzg));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)9, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzh));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)10, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzi));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)11, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzj));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)12, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzk));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)14, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzl));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)15, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzm));
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)16, (Float)this.getMinZoomPreference(), (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)17, (Float)this.getMaxZoomPreference(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)18, (Parcelable)this.getLatLngBoundsForCameraTarget(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)19, (byte)com.google.android.gms.maps.internal.zza.zzb(this.zzq));
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public GoogleMapOptions() {
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        void var1_1;
        this.zza = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        void var1_1;
        this.zzb = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions mapType(int mapType) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions camera(@Nullable CameraPosition camera) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        void var1_1;
        this.zze = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions compassEnabled(boolean enabled) {
        void var1_1;
        this.zzf = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzg = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzh = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzi = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzj = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions scrollGesturesEnabledDuringRotateOrZoom(boolean enabled) {
        void var1_1;
        this.zzq = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions liteMode(boolean enabled) {
        void var1_1;
        this.zzk = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        void var1_1;
        this.zzl = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions ambientEnabled(boolean enabled) {
        void var1_1;
        this.zzm = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions minZoomPreference(float minZoomPreference) {
        void var1_1;
        this.zzn = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions maxZoomPreference(float maxZoomPreference) {
        void var1_1;
        this.zzo = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public GoogleMapOptions latLngBoundsForCameraTarget(@Nullable LatLngBounds llbounds) {
        void var1_1;
        this.zzp = var1_1;
        return this;
    }

    @RecentlyNullable
    public Boolean getZOrderOnTop() {
        return this.zza;
    }

    @RecentlyNullable
    public Boolean getUseViewLifecycleInFragment() {
        return this.zzb;
    }

    public int getMapType() {
        return this.zzc;
    }

    @RecentlyNullable
    public CameraPosition getCamera() {
        return this.zzd;
    }

    @RecentlyNullable
    public Boolean getZoomControlsEnabled() {
        return this.zze;
    }

    @RecentlyNullable
    public Boolean getCompassEnabled() {
        return this.zzf;
    }

    @RecentlyNullable
    public Boolean getScrollGesturesEnabled() {
        return this.zzg;
    }

    @RecentlyNullable
    public Boolean getZoomGesturesEnabled() {
        return this.zzh;
    }

    @RecentlyNullable
    public Boolean getTiltGesturesEnabled() {
        return this.zzi;
    }

    @RecentlyNullable
    public Boolean getRotateGesturesEnabled() {
        return this.zzj;
    }

    @RecentlyNullable
    public Boolean getScrollGesturesEnabledDuringRotateOrZoom() {
        return this.zzq;
    }

    @RecentlyNullable
    public Boolean getLiteMode() {
        return this.zzk;
    }

    @RecentlyNullable
    public Boolean getMapToolbarEnabled() {
        return this.zzl;
    }

    @RecentlyNullable
    public Boolean getAmbientEnabled() {
        return this.zzm;
    }

    @RecentlyNullable
    public Float getMinZoomPreference() {
        return this.zzn;
    }

    @RecentlyNullable
    public Float getMaxZoomPreference() {
        return this.zzo;
    }

    @RecentlyNullable
    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzp;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public static GoogleMapOptions createFromAttributes(@Nullable Context context, @Nullable AttributeSet attrs) {
        Context context2;
        void var1_1;
        if (context == null || var1_1 == null) {
            return null;
        }
        TypedArray typedArray = context2.getResources().obtainAttributes((AttributeSet)var1_1, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom)) {
            googleMapOptions.scrollGesturesEnabledDuringRotateOrZoom(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        googleMapOptions.latLngBoundsForCameraTarget(GoogleMapOptions.zza(context2, (AttributeSet)var1_1));
        googleMapOptions.camera(GoogleMapOptions.zzb(context2, (AttributeSet)var1_1));
        typedArray.recycle();
        return googleMapOptions;
    }

    @RecentlyNonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("MapType", (Object)this.zzc).add("LiteMode", (Object)this.zzk).add("Camera", (Object)this.zzd).add("CompassEnabled", (Object)this.zzf).add("ZoomControlsEnabled", (Object)this.zze).add("ScrollGesturesEnabled", (Object)this.zzg).add("ZoomGesturesEnabled", (Object)this.zzh).add("TiltGesturesEnabled", (Object)this.zzi).add("RotateGesturesEnabled", (Object)this.zzj).add("ScrollGesturesEnabledDuringRotateOrZoom", (Object)this.zzq).add("MapToolbarEnabled", (Object)this.zzl).add("AmbientEnabled", (Object)this.zzm).add("MinZoomPreference", (Object)this.zzn).add("MaxZoomPreference", (Object)this.zzo).add("LatLngBoundsForCameraTarget", (Object)this.zzp).add("ZOrderOnTop", (Object)this.zza).add("UseViewLifecycleInFragment", (Object)this.zzb).toString();
    }

    static {
        zzab zzab2;
        CREATOR = zzab2 = new zzab();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static LatLngBounds zza(@Nullable Context object, @Nullable AttributeSet object2) {
        void var1_7;
        void var0_2;
        void var1_5;
        if (object == null) return null;
        if (var1_5 == null) {
            return null;
        }
        TypedArray typedArray = object.getResources().obtainAttributes((AttributeSet)var1_5, R.styleable.MapAttrs);
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            Float f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        } else {
            Object var0_4 = null;
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude)) {
            Float f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f));
        } else {
            Object var1_9 = null;
        }
        Float f = typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude) ? Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f)) : null;
        Float f2 = typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude) ? Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f)) : null;
        typedArray.recycle();
        if (var0_2 == null) return null;
        if (var1_7 == null) return null;
        if (f == null) return null;
        if (f2 == null) return null;
        LatLng latLng = new LatLng(var0_2.floatValue(), var1_7.floatValue());
        LatLng latLng2 = new LatLng(f.floatValue(), f2.floatValue());
        return new LatLngBounds(latLng, latLng2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static CameraPosition zzb(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        float f = typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat) ? typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f) : 0.0f;
        float f2 = typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng) ? typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f) : 0.0f;
        LatLng latLng = new LatLng(f, f2);
        CameraPosition.Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        typedArray.recycle();
        return builder.build();
    }
}

