/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzn;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaLinkCreator")
public class StreetViewPanoramaLink
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaLink> CREATOR = new zzn();
    @SafeParcelable.Field(id=2)
    public final String panoId;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    @SafeParcelable.Constructor
    public StreetViewPanoramaLink(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) float f) {
        this.panoId = string;
        this.bearing = ((double)f <= 0.0 ? f % 360.0f + 360.0f : f) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewPanoramaLink streetViewPanoramaLink = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)streetViewPanoramaLink.panoId, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)streetViewPanoramaLink.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.panoId, Float.valueOf(this.bearing)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaLink)) {
            return false;
        }
        StreetViewPanoramaLink streetViewPanoramaLink = (StreetViewPanoramaLink)((Object)object);
        return this.panoId.equals(streetViewPanoramaLink.panoId) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaLink.bearing);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("panoId", (Object)this.panoId).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }
}

