/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MarkerOptionsCreator")
public final class MarkerOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MarkerOptions> CREATOR = new zzh();
    @SafeParcelable.Field(id=2, getter="getPosition")
    private LatLng position;
    @SafeParcelable.Field(id=3, getter="getTitle")
    private String zzdm;
    @SafeParcelable.Field(id=4, getter="getSnippet")
    private String zzdn;
    @SafeParcelable.Field(id=5, getter="getWrappedIconDescriptorImplBinder", type="android.os.IBinder")
    private BitmapDescriptor zzdo;
    @SafeParcelable.Field(id=6, getter="getAnchorU")
    private float zzda = 0.5f;
    @SafeParcelable.Field(id=7, getter="getAnchorV")
    private float zzdb = 1.0f;
    @SafeParcelable.Field(id=8, getter="isDraggable")
    private boolean zzdp;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private boolean zzcs = true;
    @SafeParcelable.Field(id=10, getter="isFlat")
    private boolean zzdq = false;
    @SafeParcelable.Field(id=11, getter="getRotation")
    private float zzdr = 0.0f;
    @SafeParcelable.Field(id=12, getter="getInfoWindowAnchorU", defaultValue="0.5f")
    private float zzds = 0.5f;
    @SafeParcelable.Field(id=13, getter="getInfoWindowAnchorV")
    private float zzdt = 0.0f;
    @SafeParcelable.Field(id=14, getter="getAlpha", defaultValue="1.0f")
    private float alpha = 1.0f;
    @SafeParcelable.Field(id=15, getter="getZIndex")
    private float zzcr;

    public MarkerOptions() {
    }

    @SafeParcelable.Constructor
    MarkerOptions(@SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) IBinder iBinder, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) float f3, @SafeParcelable.Param(id=12) float f4, @SafeParcelable.Param(id=13) float f5, @SafeParcelable.Param(id=14) float f6, @SafeParcelable.Param(id=15) float f7) {
        this.position = latLng;
        this.zzdm = string;
        this.zzdn = string2;
        this.zzdo = iBinder == null ? null : new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)iBinder));
        this.zzda = f;
        this.zzdb = f2;
        this.zzdp = bl;
        this.zzcs = bl2;
        this.zzdq = bl3;
        this.zzdr = f3;
        this.zzds = f4;
        this.zzdt = f5;
        this.alpha = f6;
        this.zzcr = f7;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MarkerOptions markerOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)markerOptions.getPosition(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)markerOptions.getTitle(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)markerOptions.getSnippet(), (boolean)false);
        MarkerOptions markerOptions2 = markerOptions;
        SafeParcelWriter.writeIBinder((Parcel)parcel2, (int)5, markerOptions2.zzdo == null ? null : markerOptions2.zzdo.zza().asBinder(), (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)6, (float)markerOptions.getAnchorU());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)7, (float)markerOptions.getAnchorV());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)markerOptions.isDraggable());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)markerOptions.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)markerOptions.isFlat());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)11, (float)markerOptions.getRotation());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)12, (float)markerOptions.getInfoWindowAnchorU());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)13, (float)markerOptions.getInfoWindowAnchorV());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)14, (float)markerOptions.getAlpha());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)15, (float)markerOptions.getZIndex());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final MarkerOptions position(@NonNull LatLng latLng) {
        if (latLng == null) {
            throw new IllegalArgumentException("latlng cannot be null - a position is required.");
        }
        this.position = latLng;
        return this;
    }

    public final MarkerOptions zIndex(float f) {
        this.zzcr = f;
        return this;
    }

    public final MarkerOptions icon(@Nullable BitmapDescriptor bitmapDescriptor) {
        this.zzdo = bitmapDescriptor;
        return this;
    }

    public final MarkerOptions anchor(float f, float f2) {
        this.zzda = f;
        this.zzdb = f2;
        return this;
    }

    public final MarkerOptions infoWindowAnchor(float f, float f2) {
        this.zzds = f;
        this.zzdt = f2;
        return this;
    }

    public final MarkerOptions title(@Nullable String string) {
        this.zzdm = string;
        return this;
    }

    public final MarkerOptions snippet(@Nullable String string) {
        this.zzdn = string;
        return this;
    }

    public final MarkerOptions draggable(boolean bl) {
        this.zzdp = bl;
        return this;
    }

    public final MarkerOptions visible(boolean bl) {
        this.zzcs = bl;
        return this;
    }

    public final MarkerOptions flat(boolean bl) {
        this.zzdq = bl;
        return this;
    }

    public final MarkerOptions rotation(float f) {
        this.zzdr = f;
        return this;
    }

    public final MarkerOptions alpha(float f) {
        this.alpha = f;
        return this;
    }

    public final LatLng getPosition() {
        return this.position;
    }

    public final String getTitle() {
        return this.zzdm;
    }

    public final String getSnippet() {
        return this.zzdn;
    }

    public final BitmapDescriptor getIcon() {
        return this.zzdo;
    }

    public final float getAnchorU() {
        return this.zzda;
    }

    public final float getAnchorV() {
        return this.zzdb;
    }

    public final boolean isDraggable() {
        return this.zzdp;
    }

    public final boolean isVisible() {
        return this.zzcs;
    }

    public final boolean isFlat() {
        return this.zzdq;
    }

    public final float getRotation() {
        return this.zzdr;
    }

    public final float getInfoWindowAnchorU() {
        return this.zzds;
    }

    public final float getInfoWindowAnchorV() {
        return this.zzdt;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final float getZIndex() {
        return this.zzcr;
    }
}

