/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.model.RuntimeRemoteException;

@Hide
public class zzbz {
    private static final String zza = zzbz.class.getSimpleName();
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context zzb = null;
    private static zze zzc;

    public static zze zza(Context context) throws GooglePlayServicesNotAvailableException {
        IInterface iInterface;
        zzbq.zza((Object)context);
        if (zzc != null) {
            return zzc;
        }
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new GooglePlayServicesNotAvailableException(n);
            }
        }
        Context context2 = context;
        Log.i((String)zza, (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzbz.zza(zzbz.zzb(context2).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        zzc = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICreator")) instanceof zze ? (zze)iInterface : new zzf(iBinder));
        try {
            zzc.zza(zzn.zza((Object)zzbz.zzb(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzc;
    }

    @Nullable
    private static Context zzb(Context context) {
        if (zzb != null) {
            return zzb;
        }
        zzb = zzbz.zzc(context);
        return zzb;
    }

    @Nullable
    private static Context zzc(Context context) {
        try {
            return DynamiteModule.zza((Context)context, (DynamiteModule.zzd)DynamiteModule.zza, (String)"com.google.android.gms.maps_dynamite").zza();
        }
        catch (Throwable throwable) {
            Log.e((String)zza, (String)"Failed to load maps module, use legacy", (Throwable)throwable);
            return GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzbz.zza(((ClassLoader)zzbq.zza((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zza(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

