/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzac;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzisw;

    public MapView(Context context) {
        super(context);
        this.zzisw = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzisw = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzisw = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzisw = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzisw.onCreate(bundle);
            if (this.zzisw.zzapw() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zzisw.onResume();
    }

    public final void onPause() {
        this.zzisw.onPause();
    }

    public final void onStart() {
        this.zzisw.onStart();
    }

    public final void onStop() {
        this.zzisw.onStop();
    }

    public final void onDestroy() {
        this.zzisw.onDestroy();
    }

    public final void onLowMemory() {
        this.zzisw.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzisw.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzge((String)"getMapAsync() must be called on the main thread");
        this.zzisw.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzge((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzisw;
        if (zzb2.zzapw() != null) {
            ((zza)zzb2.zzapw()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzge((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zzisw;
        if (zzb2.zzapw() != null) {
            ((zza)zzb2.zzapw()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzita;
        private final Context zzitb;
        private zzo<zza> zzisu;
        private final GoogleMapOptions zzitc;
        private final List<OnMapReadyCallback> zzisv = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzita = viewGroup;
            this.zzitb = context;
            this.zzitc = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzisu = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzisu != null && zzb2.zzapw() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzitb);
                    IMapViewDelegate iMapViewDelegate = zzbz.zzdt(zzb2.zzitb).zza(zzn.zzz((Object)zzb2.zzitb), zzb2.zzitc);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzisu.zza((LifecycleDelegate)new zza(zzb2.zzita, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zzisv) {
                        ((zza)zzb2.zzapw()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zzisv.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzapw() != null) {
                ((zza)this.zzapw()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzisv.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzisx;
        private final IMapViewDelegate zzisy;
        private View zzisz;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzisy = (IMapViewDelegate)zzbq.checkNotNull((Object)iMapViewDelegate);
            this.zzisx = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzisy.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzisz = (View)zzn.zzx((IObjectWrapper)this.zzisy.getView());
                this.zzisx.removeAllViews();
                this.zzisx.addView(this.zzisz);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzisy.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzisy.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzisy.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzisy.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzisy.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzisy.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzisy.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzisy.getMapAsync(new zzac(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzisy.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzisy.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

