/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbej {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzirw;
    private LatLng zzirx;
    private float zziry;
    private float zzirz;
    private LatLngBounds zzinw;
    private float zzirm;
    private float zzirr;
    private boolean zzirs = true;
    private float zzisa = 0.0f;
    private float zzisb = 0.5f;
    private float zzisc = 0.5f;
    private boolean zzirt = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzirw = new BitmapDescriptor(IObjectWrapper.zza.zzap((IBinder)iBinder));
        this.zzirx = latLng;
        this.zziry = f;
        this.zzirz = f2;
        this.zzinw = latLngBounds;
        this.zzirm = f3;
        this.zzirr = f4;
        this.zzirs = bl;
        this.zzisa = f5;
        this.zzisb = f6;
        this.zzisc = f7;
        this.zzirt = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzirw.zzavn().asBinder(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbem.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbem.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbem.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbem.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbem.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbem.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbem.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbem.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzirw = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzisb = f;
        this.zzisc = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbq.zza((this.zzinw == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbq.zza((this.zzinw == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbq.checkArgument((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzirx = latLng;
        this.zziry = f;
        this.zzirz = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzirx);
        zzbq.zza((this.zzirx == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzinw = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zzirm = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzirr = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzirs = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbq.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzisa = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzirt = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzirw;
    }

    public final LatLng getLocation() {
        return this.zzirx;
    }

    public final float getWidth() {
        return this.zziry;
    }

    public final float getHeight() {
        return this.zzirz;
    }

    public final LatLngBounds getBounds() {
        return this.zzinw;
    }

    public final float getBearing() {
        return this.zzirm;
    }

    public final float getZIndex() {
        return this.zzirr;
    }

    public final float getTransparency() {
        return this.zzisa;
    }

    public final float getAnchorU() {
        return this.zzisb;
    }

    public final float getAnchorV() {
        return this.zzisc;
    }

    public final boolean isVisible() {
        return this.zzirs;
    }

    public final boolean isClickable() {
        return this.zzirt;
    }
}

