/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzac;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zziqb;

    public MapView(Context context) {
        super(context);
        this.zziqb = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zziqb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zziqb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zziqb = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zziqb.onCreate(bundle);
            if (this.zziqb.zzapk() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zziqb.onResume();
    }

    public final void onPause() {
        this.zziqb.onPause();
    }

    public final void onStart() {
        this.zziqb.onStart();
    }

    public final void onStop() {
        this.zziqb.onStop();
    }

    public final void onDestroy() {
        this.zziqb.onDestroy();
    }

    public final void onLowMemory() {
        this.zziqb.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zziqb.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzfz((String)"getMapAsync() must be called on the main thread");
        this.zziqb.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzfz((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zziqb;
        if (zzb2.zzapk() != null) {
            ((zza)zzb2.zzapk()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzfz((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zziqb;
        if (zzb2.zzapk() != null) {
            ((zza)zzb2.zzapk()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zziqf;
        private final Context zziqg;
        private zzo<zza> zzipz;
        private final GoogleMapOptions zziqh;
        private final List<OnMapReadyCallback> zziqa = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zziqf = viewGroup;
            this.zziqg = context;
            this.zziqh = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzipz = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzipz != null && zzb2.zzapk() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zziqg);
                    IMapViewDelegate iMapViewDelegate = zzbz.zzdq(zzb2.zziqg).zza(zzn.zzy((Object)zzb2.zziqg), zzb2.zziqh);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzipz.zza((LifecycleDelegate)new zza(zzb2.zziqf, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zziqa) {
                        ((zza)zzb2.zzapk()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zziqa.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzapk() != null) {
                ((zza)this.zzapk()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zziqa.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zziqc;
        private final IMapViewDelegate zziqd;
        private View zziqe;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zziqd = (IMapViewDelegate)zzbq.checkNotNull((Object)iMapViewDelegate);
            this.zziqc = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziqd.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zziqe = (View)zzn.zzx((IObjectWrapper)this.zziqd.getView());
                this.zziqc.removeAllViews();
                this.zziqc.addView(this.zziqe);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zziqd.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zziqd.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zziqd.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zziqd.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zziqd.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zziqd.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziqd.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zziqd.getMapAsync(new zzac(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziqd.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zziqd.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

