/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zzipg;
    private Boolean zziph;
    private int zzipi = -1;
    private CameraPosition zzipj;
    private Boolean zzipk;
    private Boolean zzipl;
    private Boolean zzipm;
    private Boolean zzipn;
    private Boolean zzipo;
    private Boolean zzipp;
    private Boolean zzipq;
    private Boolean zzipr;
    private Boolean zzips;
    private Float zzipt = null;
    private Float zzipu = null;
    private LatLngBounds zzipv = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzipg = zza.zza(by);
        this.zziph = zza.zza(by2);
        this.zzipi = n;
        this.zzipj = cameraPosition;
        this.zzipk = zza.zza(by3);
        this.zzipl = zza.zza(by4);
        this.zzipm = zza.zza(by5);
        this.zzipn = zza.zza(by6);
        this.zzipo = zza.zza(by7);
        this.zzipp = zza.zza(by8);
        this.zzipq = zza.zza(by9);
        this.zzipr = zza.zza(by10);
        this.zzips = zza.zza(by11);
        this.zzipt = f;
        this.zzipu = f2;
        this.zzipv = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzipg));
        zzbem.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zziph));
        zzbem.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzipk));
        zzbem.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzipl));
        zzbem.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzipm));
        zzbem.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzipn));
        zzbem.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzipo));
        zzbem.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzipp));
        zzbem.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzipq));
        zzbem.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzipr));
        zzbem.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzips));
        zzbem.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzipg = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zziph = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzipi = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzipj = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzipk = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzipl = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzipm = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzipn = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzipo = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzipp = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzipq = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzipr = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzips = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzipt = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzipu = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzipv = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzipg;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zziph;
    }

    public final int getMapType() {
        return this.zzipi;
    }

    public final CameraPosition getCamera() {
        return this.zzipj;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzipk;
    }

    public final Boolean getCompassEnabled() {
        return this.zzipl;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzipm;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzipn;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzipo;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzipp;
    }

    public final Boolean getLiteMode() {
        return this.zzipq;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzipr;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzips;
    }

    public final Float getMinZoomPreference() {
        return this.zzipt;
    }

    public final Float getMaxZoomPreference() {
        return this.zzipu;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzipv;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbg.zzw((Object)((Object)this)).zzg("MapType", (Object)this.zzipi).zzg("LiteMode", (Object)this.zzipq).zzg("Camera", (Object)this.zzipj).zzg("CompassEnabled", (Object)this.zzipl).zzg("ZoomControlsEnabled", (Object)this.zzipk).zzg("ScrollGesturesEnabled", (Object)this.zzipm).zzg("ZoomGesturesEnabled", (Object)this.zzipn).zzg("TiltGesturesEnabled", (Object)this.zzipo).zzg("RotateGesturesEnabled", (Object)this.zzipp).zzg("MapToolbarEnabled", (Object)this.zzipr).zzg("AmbientEnabled", (Object)this.zzips).zzg("MinZoomPreference", (Object)this.zzipt).zzg("MaxZoomPreference", (Object)this.zzipu).zzg("LatLngBoundsForCameraTarget", (Object)this.zzipv).zzg("ZOrderOnTop", (Object)this.zzipg).zzg("UseViewLifecycleInFragment", (Object)this.zziph).toString();
    }
}

